#!/usr/bin/env bash
set -euo pipefail

CRIT=5

log() { logger -t battery-watch "$*"; }

# Trouver une batterie (BAT0/BAT1)
BAT_DIR="$(find /sys/class/power_supply -maxdepth 1 -type l -name 'BAT*' | head -n1 || true)"
[[ -n "${BAT_DIR:-}" ]] || exit 0

CAP="$(<"$BAT_DIR/capacity")"
STATUS="$(<"$BAT_DIR/status")"   # Discharging/Charging/Full/Unknown...

# Si ça ne se décharge pas, on ne fait rien (donc jamais d'extinction en charge)
[[ "$STATUS" == "Discharging" ]] || exit 0

# Extinction uniquement si critique ET en décharge
if (( CAP <= CRIT )); then
  log "Battery critical: ${CAP}% (CRIT=${CRIT}%) while Discharging -> poweroff"
  sleep 2
  systemctl poweroff
fi

