#!/usr/bin/env bash
set -euo pipefail

WARN=10
CRIT=5

STATE_DIR="/run/user/$(id -u)/battery-watch"
mkdir -p "$STATE_DIR"

# Trouver la batterie (BAT0/BAT1)
BAT_DIR="$(find /sys/class/power_supply -maxdepth 1 -type l -name 'BAT*' | head -n1 || true)"
[[ -n "$BAT_DIR" ]] || exit 0

CAP="$(cat "$BAT_DIR/capacity")"           # 0-100
STATUS="$(cat "$BAT_DIR/status")"          # Discharging/Charging/Full

# On agit seulement si ça se décharge
[[ "$STATUS" == "Discharging" ]] || exit 0

if (( CAP <= WARN && CAP > CRIT )); then
  if [[ ! -f "$STATE_DIR/warned" ]]; then
    notify-send -u critical "Batterie faible" "${CAP}% — branche-toi (alerte à ${WARN}%)."
    touch "$STATE_DIR/warned"
  fi
fi

if (( CAP <= CRIT )); then
  notify-send -u critical "Batterie critique" "${CAP}% — extinction automatique (${CRIT}%)."
  sleep 2
  systemctl poweroff
fi

# Reset anti-spam si on remonte au-dessus de WARN
if (( CAP > WARN )); then
  rm -f "$STATE_DIR/warned" 2>/dev/null || true
fi
