/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.services.corelistener;

import javax.inject.Inject;
import org.araymond.joal.core.events.config.ConfigHasBeenLoadedEvent;
import org.araymond.joal.core.events.config.ConfigurationIsInDirtyStateEvent;
import org.araymond.joal.core.events.config.ListOfClientFilesEvent;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.impl.config.ConfigHasBeenLoadedPayload;
import org.araymond.joal.web.messages.outgoing.impl.config.ConfigIsInDirtyStatePayload;
import org.araymond.joal.web.messages.outgoing.impl.config.ListOfClientFilesPayload;
import org.araymond.joal.web.services.JoalMessageSendingTemplate;
import org.araymond.joal.web.services.corelistener.WebEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@ConditionalOnWebUi
@Service
public class WebConfigEventListener
extends WebEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebConfigEventListener.class);

    @Inject
    public WebConfigEventListener(JoalMessageSendingTemplate messagingTemplate) {
        super(messagingTemplate);
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void configHasBeenLoaded(ConfigHasBeenLoadedEvent event) {
        log.debug("Send ConfigHasBeenLoadedPayload to clients");
        this.messagingTemplate.convertAndSend("/config", (MessagePayload)new ConfigHasBeenLoadedPayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void configIsInDirtyState(ConfigurationIsInDirtyStateEvent event) {
        log.debug("Send ConfigIsInDirtyStatePayload to clients");
        this.messagingTemplate.convertAndSend("/config", (MessagePayload)new ConfigIsInDirtyStatePayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void clientFilesDiscovered(ListOfClientFilesEvent event) {
        log.debug("Send ListOfClientFilesPayload to clients");
        this.messagingTemplate.convertAndSend("/config", (MessagePayload)new ListOfClientFilesPayload(event));
    }
}

