/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.response;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import org.araymond.joal.core.bandwith.BandwidthDispatcher;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandwidthDispatcherNotifier
implements AnnounceResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(BandwidthDispatcherNotifier.class);
    private final BandwidthDispatcher bandwidthDispatcher;

    public void onAnnouncerWillAnnounce(Announcer announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
    }

    public void onAnnounceStartSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Register [{}] in bandwidth dispatcher and update stats", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        InfoHash infoHash = announcer.getTorrentInfoHash();
        this.bandwidthDispatcher.registerTorrent(infoHash);
        this.bandwidthDispatcher.updateTorrentPeers(infoHash, result.getSeeders(), result.getLeechers());
    }

    public void onAnnounceStartFails(Announcer announcer, Throwable throwable) {
    }

    public void onAnnounceRegularSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Update [{}] stats in bandwidth dispatcher", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        InfoHash infoHash = announcer.getTorrentInfoHash();
        this.bandwidthDispatcher.updateTorrentPeers(infoHash, result.getSeeders(), result.getLeechers());
    }

    public void onAnnounceRegularFails(Announcer announcer, Throwable throwable) {
    }

    public void onAnnounceStopSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Unregister [{}] from bandwidth dispatcher", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.bandwidthDispatcher.unregisterTorrent(announcer.getTorrentInfoHash());
    }

    public void onAnnounceStopFails(Announcer announcer, Throwable throwable) {
    }

    public void onTooManyAnnounceFailedInARow(Announcer announcer, TooManyAnnouncesFailedInARowException e) {
        log.debug("Unregister [{}] from bandwidth dispatcher", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.bandwidthDispatcher.unregisterTorrent(announcer.getTorrentInfoHash());
    }

    public BandwidthDispatcherNotifier(BandwidthDispatcher bandwidthDispatcher) {
        this.bandwidthDispatcher = bandwidthDispatcher;
    }
}

