/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.request;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnounceRequest;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnouncerExecutor;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncerExecutor {
    private static final Logger log = LoggerFactory.getLogger(AnnouncerExecutor.class);
    private final AnnounceResponseCallback announceResponseCallback;
    private final ThreadPoolExecutor executorService;
    private final Map<InfoHash, AnnouncerWithFuture> currentlyRunning;

    public AnnouncerExecutor(AnnounceResponseCallback announceResponseCallback) {
        this.announceResponseCallback = announceResponseCallback;
        int corePoolSize = 3;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("annnouncer-%d").build();
        this.executorService = new ThreadPoolExecutor(3, 3, 40L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.currentlyRunning = new ConcurrentHashMap();
    }

    public void execute(AnnounceRequest request) {
        Runnable task = () -> {
            try {
                this.announceResponseCallback.onAnnounceWillAnnounce(request.getEvent(), request.getAnnouncer());
                SuccessAnnounceResponse result = request.getAnnouncer().announce(request.getEvent());
                this.announceResponseCallback.onAnnounceSuccess(request.getEvent(), request.getAnnouncer(), result);
            }
            catch (TooManyAnnouncesFailedInARowException e) {
                this.announceResponseCallback.onTooManyAnnounceFailedInARow(request.getEvent(), request.getAnnouncer(), e);
            }
            catch (Throwable throwable) {
                this.announceResponseCallback.onAnnounceFailure(request.getEvent(), request.getAnnouncer(), throwable);
            }
            finally {
                this.currentlyRunning.remove(request.getAnnouncer().getTorrentInfoHash());
            }
        };
        Future<?> taskFuture = this.executorService.submit(task);
        this.currentlyRunning.put(request.getAnnouncer().getTorrentInfoHash(), new AnnouncerWithFuture(request.getAnnouncer(), taskFuture));
    }

    public Optional<Announcer> deny(InfoHash infoHash) {
        return Optional.ofNullable((AnnouncerWithFuture)this.currentlyRunning.remove(infoHash)).map(announcerFuture -> {
            announcerFuture.getFuture().cancel(true);
            return announcerFuture.getAnnouncer();
        });
    }

    public Set<Announcer> denyAll() {
        return new HashSet(this.currentlyRunning.keySet()).stream().map(arg_0 -> this.deny(arg_0)).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    public void awaitForRunningTasks() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.warn("AnnouncerExecutor timed out after 10s");
            }
        }
        catch (InterruptedException e) {
            log.warn("AnnouncerExecutor interrupt", (Throwable)e);
        }
    }
}

