/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.torrent.torrent.MockedTorrent;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFacade;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnounceDataAccessor;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.tracker.TrackerClient;
import org.araymond.joal.core.ttorrent.client.announcer.tracker.TrackerClientUriProvider;
import org.araymond.joal.core.ttorrent.client.announcer.tracker.TrackerResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Announcer
implements AnnouncerFacade {
    private static final Logger log = LoggerFactory.getLogger(Announcer.class);
    private int lastKnownInterval = 5;
    private int consecutiveFails;
    private Integer lastKnownLeechers = null;
    private Integer lastKnownSeeders = null;
    private LocalDateTime lastAnnouncedAt = null;
    private final MockedTorrent torrent;
    private TrackerClient trackerClient;
    private final AnnounceDataAccessor announceDataAccessor;
    private long reportedUploadBytes = 0L;
    private final float uploadRatioTarget;

    Announcer(MockedTorrent torrent, AnnounceDataAccessor announceDataAccessor, HttpClient httpClient, float uploadRatioTarget) {
        this.torrent = torrent;
        this.trackerClient = this.buildTrackerClient(torrent, httpClient);
        this.announceDataAccessor = announceDataAccessor;
        this.uploadRatioTarget = uploadRatioTarget;
    }

    private TrackerClient buildTrackerClient(MockedTorrent torrent, HttpClient httpClient) {
        List trackerURIs = ((Stream)torrent.getAnnounceList().stream().sequential()).flatMap(Collection::stream).collect(Collectors.toList());
        return new TrackerClient(new TrackerClientUriProvider(trackerURIs), (ResponseHandler)new TrackerResponseHandler(), httpClient);
    }

    @VisibleForTesting
    void setTrackerClient(TrackerClient trackerClient) {
        this.trackerClient = trackerClient;
    }

    public SuccessAnnounceResponse announce(TrackerMessage.AnnounceRequestMessage.RequestEvent event) throws AnnounceException, TooManyAnnouncesFailedInARowException {
        log.debug("Attempt to announce {} for {}", (Object)event.getEventName(), (Object)this.torrent.getTorrentInfoHash().getHumanReadable());
        try {
            this.lastAnnouncedAt = LocalDateTime.now();
            SuccessAnnounceResponse responseMessage = this.trackerClient.announce(this.announceDataAccessor.getHttpRequestQueryForTorrent(this.torrent.getTorrentInfoHash(), event), (Iterable)this.announceDataAccessor.getHttpHeadersForTorrent());
            log.info("{} has announced successfully. Response: {} seeders, {} leechers, {}s interval", new Object[]{this.torrent.getTorrentInfoHash().getHumanReadable(), responseMessage.getSeeders(), responseMessage.getLeechers(), responseMessage.getInterval()});
            this.reportedUploadBytes = this.announceDataAccessor.getUploaded(this.torrent.getTorrentInfoHash());
            this.lastKnownInterval = responseMessage.getInterval();
            this.lastKnownLeechers = responseMessage.getLeechers();
            this.lastKnownSeeders = responseMessage.getSeeders();
            this.consecutiveFails = 0;
            return responseMessage;
        }
        catch (Exception e) {
            ++this.consecutiveFails;
            if (this.consecutiveFails >= 5) {
                log.warn("[{}] has failed to announce {} times in a row", (Object)this.torrent.getTorrentInfoHash().getHumanReadable(), (Object)this.consecutiveFails);
                throw new TooManyAnnouncesFailedInARowException(this.torrent);
            }
            log.info("[{}] has failed to announce {}. time", (Object)this.torrent.getTorrentInfoHash().getHumanReadable(), (Object)this.consecutiveFails);
            throw e;
        }
    }

    public Optional<Integer> getLastKnownLeechers() {
        return Optional.ofNullable(this.lastKnownLeechers);
    }

    public Optional<Integer> getLastKnownSeeders() {
        return Optional.ofNullable(this.lastKnownSeeders);
    }

    public Optional<LocalDateTime> getLastAnnouncedAt() {
        return Optional.ofNullable(this.lastAnnouncedAt);
    }

    public String getTorrentName() {
        return this.torrent.getName();
    }

    public long getTorrentSize() {
        return this.torrent.getSize();
    }

    public InfoHash getTorrentInfoHash() {
        return this.getTorrent().getTorrentInfoHash();
    }

    public boolean hasReachedUploadRatioLimit() {
        if (this.uploadRatioTarget == -1.0f) {
            return false;
        }
        float bytesToUploadTarget = this.uploadRatioTarget * (float)this.getTorrentSize();
        return (float)this.reportedUploadBytes >= bytesToUploadTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equal((Object)this.getTorrentInfoHash(), (Object)((Announcer)o).getTorrentInfoHash());
    }

    public int hashCode() {
        return this.getTorrentInfoHash().hashCode();
    }

    public int getLastKnownInterval() {
        return this.lastKnownInterval;
    }

    public int getConsecutiveFails() {
        return this.consecutiveFails;
    }

    public MockedTorrent getTorrent() {
        return this.torrent;
    }
}

