/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.araymond.joal.core.config.AppConfiguration;
import org.araymond.joal.core.events.torrent.files.TorrentFileAddedEvent;
import org.araymond.joal.core.events.torrent.files.TorrentFileDeletedEvent;
import org.araymond.joal.core.exception.NoMoreTorrentsFileAvailableException;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.torrent.torrent.MockedTorrent;
import org.araymond.joal.core.torrent.watcher.TorrentFileChangeAware;
import org.araymond.joal.core.torrent.watcher.TorrentFileProvider;
import org.araymond.joal.core.ttorrent.client.ClientFacade;
import org.araymond.joal.core.ttorrent.client.DelayQueue;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFacade;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFactory;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnounceRequest;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnouncerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class Client
implements TorrentFileChangeAware,
ClientFacade {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private final AppConfiguration appConfig;
    private final TorrentFileProvider torrentFileProvider;
    private final ApplicationEventPublisher eventPublisher;
    private AnnouncerExecutor announcerExecutor;
    private final DelayQueue<AnnounceRequest> delayQueue;
    private final AnnouncerFactory announcerFactory;
    private final List<Announcer> currentlySeedingAnnouncers = new ArrayList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Thread thread;
    private volatile boolean stop = true;

    Client(AppConfiguration appConfig, TorrentFileProvider torrentFileProvider, AnnouncerExecutor announcerExecutor, DelayQueue<AnnounceRequest> delayQueue, AnnouncerFactory announcerFactory, ApplicationEventPublisher eventPublisher) {
        Preconditions.checkNotNull((Object)appConfig, (Object)"AppConfiguration must not be null");
        Preconditions.checkNotNull((Object)torrentFileProvider, (Object)"TorrentFileProvider must not be null");
        Preconditions.checkNotNull(delayQueue, (Object)"DelayQueue must not be null");
        Preconditions.checkNotNull((Object)announcerFactory, (Object)"AnnouncerFactory must not be null");
        this.eventPublisher = eventPublisher;
        this.appConfig = appConfig;
        this.torrentFileProvider = torrentFileProvider;
        this.announcerExecutor = announcerExecutor;
        this.delayQueue = delayQueue;
        this.announcerFactory = announcerFactory;
    }

    @VisibleForTesting
    void setAnnouncerExecutor(AnnouncerExecutor announcerExecutor) {
        this.announcerExecutor = announcerExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.stop = false;
        this.thread = new Thread(() -> {
            while (!this.stop) {
                this.delayQueue.getAvailables().forEach(req -> {
                    this.announcerExecutor.execute(req);
                    try {
                        this.lock.writeLock().lock();
                        this.currentlySeedingAnnouncers.remove(req.getAnnouncer());
                        this.currentlySeedingAnnouncers.add(req.getAnnouncer());
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                });
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        for (int i = 0; i < this.appConfig.getSimultaneousSeed(); ++i) {
            try {
                lock.lock();
                this.addTorrentFromDirectory();
                continue;
            }
            catch (NoMoreTorrentsFileAvailableException ignored) {
                break;
            }
            finally {
                lock.unlock();
            }
        }
        this.thread.setName("client-orchestrator-thread");
        this.thread.start();
        this.torrentFileProvider.registerListener((TorrentFileChangeAware)this);
    }

    private void addTorrentFromDirectory() throws NoMoreTorrentsFileAvailableException {
        MockedTorrent torrent = this.torrentFileProvider.getTorrentNotIn((Collection)this.currentlySeedingAnnouncers.stream().map(Announcer::getTorrentInfoHash).collect(Collectors.toSet()));
        this.addTorrent(torrent);
    }

    private void addTorrent(MockedTorrent torrent) {
        Announcer announcer = this.announcerFactory.create(torrent);
        this.currentlySeedingAnnouncers.add(announcer);
        this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createStart((Announcer)announcer), 0, (TemporalUnit)ChronoUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.stop = true;
            this.torrentFileProvider.unRegisterListener((TorrentFileChangeAware)this);
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.thread = null;
                }
            }
            this.delayQueue.drainAll().stream().filter(req -> req.getEvent() != TrackerMessage.AnnounceRequestMessage.RequestEvent.STARTED).map(AnnounceRequest::toStop).forEach(arg_0 -> ((AnnouncerExecutor)this.announcerExecutor).execute(arg_0));
            this.announcerExecutor.awaitForRunningTasks();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTooManyFailedInARow(Announcer announcer) {
        if (this.stop) {
            this.currentlySeedingAnnouncers.remove(announcer);
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.currentlySeedingAnnouncers.remove(announcer);
            this.torrentFileProvider.moveToArchiveFolder(announcer.getTorrentInfoHash());
            this.addTorrentFromDirectory();
        }
        catch (NoMoreTorrentsFileAvailableException noMoreTorrentsFileAvailableException) {
        }
        finally {
            lock.unlock();
        }
    }

    public void onNoMorePeers(InfoHash infoHash) {
        if (!this.appConfig.isKeepTorrentWithZeroLeechers()) {
            this.torrentFileProvider.moveToArchiveFolder(infoHash);
        }
    }

    public void onUploadRatioLimitReached(InfoHash infoHash) {
        log.info("Deleting torrent [{}] since ratio has been met", (Object)infoHash);
        this.torrentFileProvider.moveToArchiveFolder(infoHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTorrentHasStopped(Announcer stoppedAnnouncer) {
        if (this.stop) {
            this.currentlySeedingAnnouncers.remove(stoppedAnnouncer);
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.addTorrentFromDirectory();
        }
        catch (NoMoreTorrentsFileAvailableException noMoreTorrentsFileAvailableException) {
        }
        finally {
            this.currentlySeedingAnnouncers.remove(stoppedAnnouncer);
            lock.unlock();
        }
    }

    public void onTorrentFileAdded(MockedTorrent torrent) {
        this.eventPublisher.publishEvent((Object)new TorrentFileAddedEvent(torrent));
        if (!this.stop && this.currentlySeedingAnnouncers.size() < this.appConfig.getSimultaneousSeed()) {
            ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
            try {
                lock.lock();
                this.addTorrent(torrent);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void onTorrentFileRemoved(MockedTorrent torrent) {
        this.eventPublisher.publishEvent((Object)new TorrentFileDeletedEvent(torrent));
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.currentlySeedingAnnouncers.stream().filter(announcer -> announcer.getTorrentInfoHash().equals((Object)torrent.getTorrentInfoHash())).findAny().ifPresent(announcer -> this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createStop((Announcer)announcer), 1, (TemporalUnit)ChronoUnit.SECONDS));
        }
        finally {
            lock.unlock();
        }
    }

    public List<AnnouncerFacade> getCurrentlySeedingAnnouncers() {
        ReentrantReadWriteLock.ReadLock lock = this.lock.readLock();
        try {
            lock.lock();
            ArrayList<AnnouncerFacade> arrayList = new ArrayList<AnnouncerFacade>(this.currentlySeedingAnnouncers);
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }
}

