/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Provider;
import org.araymond.joal.core.SeedManager;
import org.araymond.joal.core.config.AppConfiguration;
import org.araymond.joal.core.events.config.ConfigHasBeenLoadedEvent;
import org.araymond.joal.core.events.config.ConfigurationIsInDirtyStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class JoalConfigProvider
implements Provider<AppConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(JoalConfigProvider.class);
    private static final String CONF_FILE_NAME = "config.json";
    private final Path joalConfFile;
    private final ObjectMapper objectMapper;
    private AppConfiguration config;
    private final ApplicationEventPublisher appEventPublisher;

    public JoalConfigProvider(ObjectMapper objectMapper, SeedManager.JoalFoldersPath joalFoldersPath, ApplicationEventPublisher appEventPublisher) throws FileNotFoundException {
        this.objectMapper = objectMapper;
        this.appEventPublisher = appEventPublisher;
        this.joalConfFile = joalFoldersPath.getConfDirRootPath().resolve(CONF_FILE_NAME);
        if (!Files.isRegularFile(this.joalConfFile, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("App configuration file [%s] not found", this.joalConfFile));
        }
        log.debug("App configuration file will be searched for in [{}]", (Object)this.joalConfFile.toAbsolutePath());
    }

    public AppConfiguration init() {
        this.config = this.loadConfiguration();
        return this.config;
    }

    public AppConfiguration get() {
        if (this.config == null) {
            log.error("App configuration has not been loaded yet");
            throw new IllegalStateException("Attempted to get configuration before init");
        }
        return this.config;
    }

    @VisibleForTesting
    AppConfiguration loadConfiguration() {
        AppConfiguration conf;
        try {
            log.debug("Reading json configuration from [{}]...", (Object)this.joalConfFile.toAbsolutePath());
            conf = (AppConfiguration)this.objectMapper.readValue(this.joalConfFile.toFile(), AppConfiguration.class);
            log.debug("Successfully read json configuration");
        }
        catch (IOException e) {
            log.error("Failed to read configuration file", (Throwable)e);
            throw new IllegalStateException(e);
        }
        log.info("App configuration has been successfully loaded");
        this.appEventPublisher.publishEvent((Object)new ConfigHasBeenLoadedEvent(conf));
        return conf;
    }

    public void saveNewConf(AppConfiguration conf) {
        try {
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(this.joalConfFile.toFile(), (Object)conf);
            this.appEventPublisher.publishEvent((Object)new ConfigurationIsInDirtyStateEvent(conf));
        }
        catch (IOException e) {
            log.error("Failed to write new configuration file", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

