/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.peerid.generation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.security.SecureRandom;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.araymond.joal.core.client.emulated.TorrentClientConfigIntegrityException;
import org.araymond.joal.core.client.emulated.generator.peerid.generation.PeerIdAlgorithm;

public class RandomPoolWithChecksumPeerIdAlgorithm
implements PeerIdAlgorithm {
    private final SecureRandom random;
    private int refreshSeedAfter;
    private int generationCount;
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="charactersPool")
    private final String charactersPool;
    @JsonProperty(value="base")
    private final Integer base;

    public RandomPoolWithChecksumPeerIdAlgorithm(@JsonProperty(value="prefix", required=true) String prefix, @JsonProperty(value="charactersPool", required=true) String charactersPool, @JsonProperty(value="base", required=true) Integer base) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            throw new TorrentClientConfigIntegrityException("peerId algorithm prefix must not be null or empty.");
        }
        if (StringUtils.isBlank((CharSequence)charactersPool)) {
            throw new TorrentClientConfigIntegrityException("peerId algorithm charactersPool must not be null or empty.");
        }
        if (base == null) {
            throw new TorrentClientConfigIntegrityException("peerId algorithm base must not be null.");
        }
        this.random = new SecureRandom(this.createSecureRandomSeed());
        this.refreshSeedAfter = this.getRandomIntBetween10And50();
        this.generationCount = 0;
        this.prefix = prefix;
        this.charactersPool = charactersPool;
        this.base = base;
    }

    @VisibleForTesting
    byte[] createSecureRandomSeed() {
        return Instant.now().toString().getBytes(Charsets.UTF_8);
    }

    private int getRandomIntBetween10And50() {
        int randNumber = new SecureRandom(this.createSecureRandomSeed()).nextInt();
        randNumber = Math.abs(randNumber % 40);
        return randNumber + 10;
    }

    @VisibleForTesting
    byte[] generateRandomBytes(int length) {
        if (this.generationCount >= this.refreshSeedAfter) {
            this.generationCount = 0;
            this.random.setSeed(this.createSecureRandomSeed());
            this.refreshSeedAfter = this.getRandomIntBetween10And50();
        }
        ++this.generationCount;
        byte[] bytes = new byte[length];
        this.random.nextBytes(bytes);
        return bytes;
    }

    public String generate() {
        int val;
        int suffixLength = 20 - this.prefix.length();
        byte[] randomBytes = this.generateRandomBytes(suffixLength - 1);
        char[] buf = new char[suffixLength];
        int total = 0;
        for (int i = 0; i < suffixLength - 1; ++i) {
            val = randomBytes[i] < 0 ? randomBytes[i] + 256 : randomBytes[i];
            total += (val %= this.base.intValue());
            buf[i] = this.charactersPool.charAt(val);
        }
        val = total % this.base != 0 ? this.base - total % this.base : 0;
        buf[suffixLength - 1] = this.charactersPool.charAt(val);
        return this.prefix + new String(buf);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomPoolWithChecksumPeerIdAlgorithm)) {
            return false;
        }
        RandomPoolWithChecksumPeerIdAlgorithm other = (RandomPoolWithChecksumPeerIdAlgorithm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$base = this.getBase();
        Integer other$base = other.getBase();
        if (this$base == null ? other$base != null : !((Object)this$base).equals(other$base)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$charactersPool = this.getCharactersPool();
        String other$charactersPool = other.getCharactersPool();
        return !(this$charactersPool == null ? other$charactersPool != null : !this$charactersPool.equals(other$charactersPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RandomPoolWithChecksumPeerIdAlgorithm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $charactersPool = this.getCharactersPool();
        result = result * 59 + ($charactersPool == null ? 43 : $charactersPool.hashCode());
        return result;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCharactersPool() {
        return this.charactersPool;
    }

    public Integer getBase() {
        return this.base;
    }
}

