/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.services.corelistener;

import javax.inject.Inject;
import org.araymond.joal.core.events.announce.FailedToAnnounceEvent;
import org.araymond.joal.core.events.announce.SuccessfullyAnnounceEvent;
import org.araymond.joal.core.events.announce.TooManyAnnouncesFailedEvent;
import org.araymond.joal.core.events.announce.WillAnnounceEvent;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.impl.announce.FailedToAnnouncePayload;
import org.araymond.joal.web.messages.outgoing.impl.announce.SuccessfullyAnnouncePayload;
import org.araymond.joal.web.messages.outgoing.impl.announce.TooManyAnnouncesFailedPayload;
import org.araymond.joal.web.messages.outgoing.impl.announce.WillAnnouncePayload;
import org.araymond.joal.web.services.JoalMessageSendingTemplate;
import org.araymond.joal.web.services.corelistener.WebEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@ConditionalOnWebUi
@Service
public class WebAnnounceEventListener
extends WebEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebAnnounceEventListener.class);

    @Inject
    public WebAnnounceEventListener(JoalMessageSendingTemplate messagingTemplate) {
        super(messagingTemplate);
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void failedToAnnounce(FailedToAnnounceEvent event) {
        log.debug("Send FailedToAnnouncePayload to clients.");
        this.messagingTemplate.convertAndSend("/announce", (MessagePayload)new FailedToAnnouncePayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void successfullyAnnounce(SuccessfullyAnnounceEvent event) {
        log.debug("Send SuccessfullyAnnouncePayload to clients.");
        this.messagingTemplate.convertAndSend("/announce", (MessagePayload)new SuccessfullyAnnouncePayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void tooManyAnnouncesFailed(TooManyAnnouncesFailedEvent event) {
        log.debug("Send TooManyAnnouncesFailedPayload to clients.");
        this.messagingTemplate.convertAndSend("/announce", (MessagePayload)new TooManyAnnouncesFailedPayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void willAnnounce(WillAnnounceEvent event) {
        log.debug("Send WillAnnouncePayload to clients.");
        this.messagingTemplate.convertAndSend("/announce", (MessagePayload)new WillAnnouncePayload(event));
    }
}

