/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.config.security.websocket.services;

import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@ConditionalOnWebUi
@Component
public class WebSocketAuthenticatorService {
    private final String appSecretToken;

    public WebSocketAuthenticatorService(@Value(value="${joal.ui.secret-token}") String appSecretToken) {
        this.appSecretToken = appSecretToken;
    }

    public UsernamePasswordAuthenticationToken getAuthenticatedOrFail(CharSequence username, CharSequence authToken) throws AuthenticationException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AuthenticationCredentialsNotFoundException("Username was null or empty.");
        }
        if (StringUtils.isBlank((CharSequence)authToken)) {
            throw new AuthenticationCredentialsNotFoundException("Authentication token was null or empty.");
        }
        if (!this.appSecretToken.contentEquals(authToken)) {
            throw new BadCredentialsException("Authentication token does not match the expected token");
        }
        return new UsernamePasswordAuthenticationToken((Object)username, null, Collections.singleton((GrantedAuthority & Serializable)() -> "USER"));
    }
}

