/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.config;

import javax.inject.Inject;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;

@ConditionalOnWebUi
@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    private final String webSocketPathPrefix;

    @Inject
    public WebSocketConfig(@Value(value="${joal.ui.path.prefix}") String webSocketPathPrefix) {
        this.webSocketPathPrefix = webSocketPathPrefix;
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(5120000).setSendBufferSizeLimit(5120000);
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/global", "/announce", "/config", "/torrents", "/speed"});
        config.setApplicationDestinationPrefixes(new String[]{"/joal"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.webSocketPathPrefix}).setAllowedOrigins(new String[]{"*"});
    }
}

