/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client;

import org.araymond.joal.core.bandwith.BandwidthDispatcher;
import org.araymond.joal.core.config.AppConfiguration;
import org.araymond.joal.core.torrent.watcher.TorrentFileProvider;
import org.araymond.joal.core.ttorrent.client.Client;
import org.araymond.joal.core.ttorrent.client.ClientFacade;
import org.araymond.joal.core.ttorrent.client.DelayQueue;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFactory;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnounceRequest;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnouncerExecutor;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceEventPublisher;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceReEnqueuer;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseCallback;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandler;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandlerChain;
import org.araymond.joal.core.ttorrent.client.announcer.response.BandwidthDispatcherNotifier;
import org.araymond.joal.core.ttorrent.client.announcer.response.ClientNotifier;
import org.springframework.context.ApplicationEventPublisher;

public final class ClientBuilder {
    private AppConfiguration appConfiguration;
    private TorrentFileProvider torrentFileProvider;
    private BandwidthDispatcher bandwidthDispatcher;
    private AnnouncerFactory announcerFactory;
    private ApplicationEventPublisher eventPublisher;
    private DelayQueue<AnnounceRequest> delayQueue;

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public ClientBuilder withAppConfiguration(AppConfiguration appConfiguration) {
        this.appConfiguration = appConfiguration;
        return this;
    }

    public ClientBuilder withTorrentFileProvider(TorrentFileProvider torrentFileProvider) {
        this.torrentFileProvider = torrentFileProvider;
        return this;
    }

    public ClientBuilder withBandwidthDispatcher(BandwidthDispatcher bandwidthDispatcher) {
        this.bandwidthDispatcher = bandwidthDispatcher;
        return this;
    }

    public ClientBuilder withAnnouncerFactory(AnnouncerFactory announcerFactory) {
        this.announcerFactory = announcerFactory;
        return this;
    }

    public ClientBuilder withEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        return this;
    }

    public ClientBuilder withDelayQueue(DelayQueue<AnnounceRequest> delayQueue) {
        this.delayQueue = delayQueue;
        return this;
    }

    public ClientFacade build() {
        AnnounceResponseHandlerChain announceResponseCallback = new AnnounceResponseHandlerChain();
        announceResponseCallback.appendHandler((AnnounceResponseHandler)new AnnounceEventPublisher(this.eventPublisher));
        announceResponseCallback.appendHandler((AnnounceResponseHandler)new AnnounceReEnqueuer(this.delayQueue));
        announceResponseCallback.appendHandler((AnnounceResponseHandler)new BandwidthDispatcherNotifier(this.bandwidthDispatcher));
        AnnouncerExecutor announcerExecutor = new AnnouncerExecutor((AnnounceResponseCallback)announceResponseCallback);
        Client client = new Client(this.appConfiguration, this.torrentFileProvider, announcerExecutor, this.delayQueue, this.announcerFactory, this.eventPublisher);
        announceResponseCallback.appendHandler((AnnounceResponseHandler)new ClientNotifier(client));
        return client;
    }

    private ClientBuilder() {
    }
}

