/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.peerid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import org.araymond.joal.core.client.emulated.TorrentClientConfigIntegrityException;
import org.araymond.joal.core.client.emulated.generator.peerid.AlwaysRefreshPeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.NeverRefreshPeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.TimedRefreshPeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.TorrentPersistentRefreshPeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.TorrentVolatileRefreshPeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.generation.PeerIdAlgorithm;
import org.araymond.joal.core.torrent.torrent.InfoHash;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="refreshOn")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NeverRefreshPeerIdGenerator.class, name="NEVER"), @JsonSubTypes.Type(value=AlwaysRefreshPeerIdGenerator.class, name="ALWAYS"), @JsonSubTypes.Type(value=TimedRefreshPeerIdGenerator.class, name="TIMED"), @JsonSubTypes.Type(value=TorrentVolatileRefreshPeerIdGenerator.class, name="TORRENT_VOLATILE"), @JsonSubTypes.Type(value=TorrentPersistentRefreshPeerIdGenerator.class, name="TORRENT_PERSISTENT")})
public abstract class PeerIdGenerator {
    public static final int PEER_ID_LENGTH = 20;
    @JsonProperty(value="algorithm")
    private final PeerIdAlgorithm algorithm;
    @JsonProperty(value="shouldUrlEncode")
    private final boolean shouldUrlEncode;

    protected PeerIdGenerator(PeerIdAlgorithm algorithm, boolean shouldUrlEncode) {
        if (algorithm == null) {
            throw new TorrentClientConfigIntegrityException("peerId algorithm must not be null");
        }
        this.algorithm = algorithm;
        this.shouldUrlEncode = shouldUrlEncode;
    }

    @JsonIgnore
    public abstract String getPeerId(InfoHash var1, TrackerMessage.AnnounceRequestMessage.RequestEvent var2);

    protected String generatePeerId() {
        String peerId = this.algorithm.generate();
        if (peerId.length() != 20) {
            throw new IllegalStateException("PeerId length was supposed to be 20, but a length of " + peerId.length() + " was generated. Throw exception to prevent sending invalid PeerId to tracker");
        }
        return peerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerIdGenerator)) {
            return false;
        }
        PeerIdGenerator other = (PeerIdGenerator)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShouldUrlEncode() != other.isShouldUrlEncode()) {
            return false;
        }
        PeerIdAlgorithm this$algorithm = this.getAlgorithm();
        PeerIdAlgorithm other$algorithm = other.getAlgorithm();
        return !(this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PeerIdGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldUrlEncode() ? 79 : 97);
        PeerIdAlgorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        return result;
    }

    public PeerIdAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public boolean isShouldUrlEncode() {
        return this.shouldUrlEncode;
    }
}

