/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.araymond.joal.core.client.emulated.generator.key.KeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.algorithm.KeyAlgorithm;
import org.araymond.joal.core.client.emulated.utils.Casing;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class TorrentVolatileRefreshKeyGenerator
extends KeyGenerator {
    private final Map<InfoHash, String> keyPerTorrent = new ConcurrentHashMap();

    @JsonCreator
    TorrentVolatileRefreshKeyGenerator(@JsonProperty(value="algorithm", required=true) KeyAlgorithm algorithm, @JsonProperty(value="keyCase", required=true) Casing keyCase) {
        super(algorithm, keyCase);
    }

    public String getKey(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        if (!this.keyPerTorrent.containsKey(infoHash)) {
            this.keyPerTorrent.put(infoHash, super.generateKey());
        }
        String key = (String)this.keyPerTorrent.get(infoHash);
        if (event == TrackerMessage.AnnounceRequestMessage.RequestEvent.STOPPED) {
            this.keyPerTorrent.remove(infoHash);
        }
        return key;
    }
}

