/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.key;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import org.araymond.joal.core.client.emulated.TorrentClientConfigIntegrityException;
import org.araymond.joal.core.client.emulated.generator.key.AlwaysRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.NeverRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.TimedOrAfterStartedAnnounceRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.TimedRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.TorrentPersistentRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.TorrentVolatileRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.algorithm.KeyAlgorithm;
import org.araymond.joal.core.client.emulated.utils.Casing;
import org.araymond.joal.core.torrent.torrent.InfoHash;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="refreshOn")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NeverRefreshKeyGenerator.class, name="NEVER"), @JsonSubTypes.Type(value=AlwaysRefreshKeyGenerator.class, name="ALWAYS"), @JsonSubTypes.Type(value=TimedRefreshKeyGenerator.class, name="TIMED"), @JsonSubTypes.Type(value=TimedOrAfterStartedAnnounceRefreshKeyGenerator.class, name="TIMED_OR_AFTER_STARTED_ANNOUNCE"), @JsonSubTypes.Type(value=TorrentVolatileRefreshKeyGenerator.class, name="TORRENT_VOLATILE"), @JsonSubTypes.Type(value=TorrentPersistentRefreshKeyGenerator.class, name="TORRENT_PERSISTENT")})
public abstract class KeyGenerator {
    @JsonProperty(value="algorithm")
    private final KeyAlgorithm algorithm;
    @JsonProperty(value="keyCase")
    private final Casing keyCase;

    protected KeyGenerator(KeyAlgorithm keyAlgorithm, Casing keyCase) {
        if (keyAlgorithm == null) {
            throw new TorrentClientConfigIntegrityException("key algorithm must not be null");
        }
        this.algorithm = keyAlgorithm;
        this.keyCase = keyCase;
    }

    @JsonIgnore
    public abstract String getKey(InfoHash var1, TrackerMessage.AnnounceRequestMessage.RequestEvent var2);

    protected String generateKey() {
        return this.keyCase.toCase(this.algorithm.generate());
    }

    public KeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Casing getKeyCase() {
        return this.keyCase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyGenerator)) {
            return false;
        }
        KeyGenerator other = (KeyGenerator)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        KeyAlgorithm this$algorithm = this.getAlgorithm();
        KeyAlgorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        Casing this$keyCase = this.getKeyCase();
        Casing other$keyCase = other.getKeyCase();
        return !(this$keyCase == null ? other$keyCase != null : !this$keyCase.equals(other$keyCase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KeyAlgorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        Casing $keyCase = this.getKeyCase();
        result = result * 59 + ($keyCase == null ? 43 : $keyCase.hashCode());
        return result;
    }
}

