/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableSet;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.araymond.joal.core.bandwith.TorrentSeedStats;
import org.araymond.joal.core.client.emulated.BitTorrentClientConfig;
import org.araymond.joal.core.client.emulated.generator.UrlEncoder;
import org.araymond.joal.core.client.emulated.generator.key.KeyGenerator;
import org.araymond.joal.core.client.emulated.generator.numwant.NumwantProvider;
import org.araymond.joal.core.client.emulated.generator.peerid.PeerIdGenerator;
import org.araymond.joal.core.exception.UnrecognizedClientPlaceholder;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.ttorrent.client.ConnectionHandler;

public class BitTorrentClient {
    private final PeerIdGenerator peerIdGenerator;
    private final KeyGenerator keyGenerator;
    private final UrlEncoder urlEncoder;
    private final String query;
    private final Set<Map.Entry<String, String>> headers;
    private final NumwantProvider numwantProvider;
    private static final Pattern INFOHASH_PTRN = Pattern.compile("\\{infohash}");
    private static final Pattern UPLOADED_PTRN = Pattern.compile("\\{uploaded}");
    private static final Pattern DOWNLOADED_PTRN = Pattern.compile("\\{downloaded}");
    private static final Pattern LEFT_PTRN = Pattern.compile("\\{left}");
    private static final Pattern PORT_PTRN = Pattern.compile("\\{port}");
    private static final Pattern NUMWANT_PTRN = Pattern.compile("\\{numwant}");
    private static final Pattern PEER_ID_PTRN = Pattern.compile("\\{peerid}");
    private static final Pattern EVENT_PTRN = Pattern.compile("\\{event}");
    private static final Pattern KEY_PTRN = Pattern.compile("\\{key}");
    private static final Pattern JAVA_PTRN = Pattern.compile("\\{java}");
    private static final Pattern OS_PTRN = Pattern.compile("\\{os}");
    private static final Pattern LOCALE_PTRN = Pattern.compile("\\{locale}");
    private static final Pattern AMPERSAND_DUPES_PTRN = Pattern.compile("&{2,}");
    private static final Pattern IP_PTRN = Pattern.compile("\\{ip}");
    private static final Pattern IPV6_PTRN = Pattern.compile("\\{ipv6}");
    private static final Pattern IP_Q_PTRN = Pattern.compile("&*\\w+=\\{ip(?:v6)?}");
    private static final Pattern EVENT_Q_PTRN = Pattern.compile("&*\\w+=\\{event}");
    private static final Pattern PLACEHOLDER_PTRN = Pattern.compile("\\{.*?}");

    BitTorrentClient(PeerIdGenerator peerIdGenerator, KeyGenerator keyGenerator, UrlEncoder urlEncoder, String query, Collection<BitTorrentClientConfig.HttpHeader> headers, NumwantProvider numwantProvider) {
        Preconditions.checkNotNull((Object)peerIdGenerator, (Object)"peerIdGenerator cannot be null or empty");
        Preconditions.checkNotNull((Object)urlEncoder, (Object)"urlEncoder cannot be null");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)query) ? 1 : 0) != 0, (Object)"query cannot be null or empty");
        Preconditions.checkNotNull(headers, (Object)"headers cannot be null");
        Preconditions.checkNotNull((Object)numwantProvider, (Object)"numwantProvider cannot be null");
        this.peerIdGenerator = peerIdGenerator;
        this.urlEncoder = urlEncoder;
        this.query = AMPERSAND_DUPES_PTRN.matcher(query).replaceAll("&");
        this.headers = this.createRequestHeaders(headers);
        this.keyGenerator = keyGenerator;
        this.numwantProvider = numwantProvider;
    }

    @VisibleForTesting
    public String getPeerId(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        return this.peerIdGenerator.getPeerId(infoHash, event);
    }

    @VisibleForTesting
    Optional<String> getKey(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        return Optional.ofNullable(this.keyGenerator).map(keyGen -> keyGen.getKey(infoHash, event));
    }

    @VisibleForTesting
    int getNumwant(TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        return this.numwantProvider.get(event);
    }

    public String createRequestQuery(TrackerMessage.AnnounceRequestMessage.RequestEvent event, InfoHash torrentInfoHash, TorrentSeedStats stats, ConnectionHandler connectionHandler) {
        Matcher placeholderMatcher;
        String q = INFOHASH_PTRN.matcher(this.getQuery()).replaceAll(this.urlEncoder.encode(torrentInfoHash.value()));
        q = UPLOADED_PTRN.matcher(q).replaceAll(String.valueOf(stats.getUploaded()));
        q = DOWNLOADED_PTRN.matcher(q).replaceAll(String.valueOf(stats.getDownloaded()));
        q = LEFT_PTRN.matcher(q).replaceAll(String.valueOf(stats.getLeft()));
        q = PORT_PTRN.matcher(q).replaceAll(String.valueOf(connectionHandler.getPort()));
        q = NUMWANT_PTRN.matcher(q).replaceAll(String.valueOf(this.getNumwant(event)));
        String peerId = this.peerIdGenerator.isShouldUrlEncode() ? this.urlEncoder.encode(this.getPeerId(torrentInfoHash, event)) : this.getPeerId(torrentInfoHash, event);
        q = PEER_ID_PTRN.matcher(q).replaceAll(peerId);
        InetAddress addy = connectionHandler.getIpAddress();
        if (q.contains("{ip}") && addy instanceof Inet4Address) {
            q = IP_PTRN.matcher(q).replaceAll(addy.getHostAddress());
        } else if (q.contains("{ipv6}") && addy instanceof Inet6Address) {
            q = IPV6_PTRN.matcher(q).replaceAll(this.urlEncoder.encode(addy.getHostAddress()));
        }
        q = IP_Q_PTRN.matcher(q).replaceAll("");
        q = event == null || event == TrackerMessage.AnnounceRequestMessage.RequestEvent.NONE ? EVENT_Q_PTRN.matcher(q).replaceAll("") : EVENT_PTRN.matcher(q).replaceAll(event.getEventName());
        if (q.contains("{key}")) {
            String key = (String)this.getKey(torrentInfoHash, event).orElseThrow(() -> new IllegalStateException("Client request query contains 'key' but BitTorrentClient does not have a key"));
            q = KEY_PTRN.matcher(q).replaceAll(this.urlEncoder.encode(key));
        }
        if ((placeholderMatcher = PLACEHOLDER_PTRN.matcher(q)).find()) {
            throw new UnrecognizedClientPlaceholder("Placeholder [" + placeholderMatcher.group() + "] were not recognized while building announce URL");
        }
        if (q.endsWith("&")) {
            q = q.substring(0, q.length() - 1);
        }
        if (q.startsWith("&")) {
            q = q.substring(1);
        }
        return q;
    }

    private Set<Map.Entry<String, String>> createRequestHeaders(Collection<BitTorrentClientConfig.HttpHeader> headers) {
        return (Set)headers.stream().map(hdr -> {
            String value = JAVA_PTRN.matcher(hdr.getValue()).replaceAll(System.getProperty(StandardSystemProperty.JAVA_VERSION.key()));
            value = OS_PTRN.matcher(value).replaceAll(System.getProperty(StandardSystemProperty.OS_NAME.key()));
            Matcher placeholderMatcher = PLACEHOLDER_PTRN.matcher(value = LOCALE_PTRN.matcher(value).replaceAll(Locale.getDefault().toLanguageTag()));
            if (placeholderMatcher.find()) {
                throw new UnrecognizedClientPlaceholder("Placeholder [" + placeholderMatcher.group() + "] were not recognized while building client Headers");
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>(hdr.getName(), value);
        }).collect(ImmutableSet.toImmutableSet());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitTorrentClient)) {
            return false;
        }
        BitTorrentClient other = (BitTorrentClient)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PeerIdGenerator this$peerIdGenerator = this.peerIdGenerator;
        PeerIdGenerator other$peerIdGenerator = other.peerIdGenerator;
        if (this$peerIdGenerator == null ? other$peerIdGenerator != null : !this$peerIdGenerator.equals(other$peerIdGenerator)) {
            return false;
        }
        KeyGenerator this$keyGenerator = this.keyGenerator;
        KeyGenerator other$keyGenerator = other.keyGenerator;
        if (this$keyGenerator == null ? other$keyGenerator != null : !this$keyGenerator.equals(other$keyGenerator)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Set this$headers = this.getHeaders();
        Set other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        NumwantProvider this$numwantProvider = this.numwantProvider;
        NumwantProvider other$numwantProvider = other.numwantProvider;
        return !(this$numwantProvider == null ? other$numwantProvider != null : !this$numwantProvider.equals(other$numwantProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitTorrentClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PeerIdGenerator $peerIdGenerator = this.peerIdGenerator;
        result = result * 59 + ($peerIdGenerator == null ? 43 : $peerIdGenerator.hashCode());
        KeyGenerator $keyGenerator = this.keyGenerator;
        result = result * 59 + ($keyGenerator == null ? 43 : $keyGenerator.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Set $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        NumwantProvider $numwantProvider = this.numwantProvider;
        result = result * 59 + ($numwantProvider == null ? 43 : $numwantProvider.hashCode());
        return result;
    }

    public String getQuery() {
        return this.query;
    }

    public Set<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }
}

