/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal;

import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.araymond.joal.core.SeedManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
public class ApplicationClosingListener
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationClosingListener.class);
    private final SeedManager manager;

    @Inject
    public ApplicationClosingListener(SeedManager manager) {
        this.manager = manager;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        log.info("Gracefully shutting down application...");
        this.manager.stop();
        this.manager.tearDown();
        log.info("JOAL gracefully shut down");
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        loggerContext.stop();
    }
}

