/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.services.corelistener;

import javax.inject.Inject;
import org.araymond.joal.core.events.torrent.files.FailedToAddTorrentFileEvent;
import org.araymond.joal.core.events.torrent.files.TorrentFileAddedEvent;
import org.araymond.joal.core.events.torrent.files.TorrentFileDeletedEvent;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.impl.files.FailedToAddTorrentFilePayload;
import org.araymond.joal.web.messages.outgoing.impl.files.TorrentFileAddedPayload;
import org.araymond.joal.web.messages.outgoing.impl.files.TorrentFileDeletedPayload;
import org.araymond.joal.web.services.JoalMessageSendingTemplate;
import org.araymond.joal.web.services.corelistener.WebEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@ConditionalOnWebUi
@Service
public class WebTorrentFileEventListener
extends WebEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebTorrentFileEventListener.class);

    @Inject
    public WebTorrentFileEventListener(JoalMessageSendingTemplate messagingTemplate) {
        super(messagingTemplate);
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void torrentFileAdded(TorrentFileAddedEvent event) {
        log.debug("Send TorrentFileAddedPayload to clients.");
        this.messagingTemplate.convertAndSend("/torrents", (MessagePayload)new TorrentFileAddedPayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void torrentFileDeleted(TorrentFileDeletedEvent event) {
        log.debug("Send TorrentFileDeletedPayload to clients.");
        this.messagingTemplate.convertAndSend("/torrents", (MessagePayload)new TorrentFileDeletedPayload(event));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void failedToAddTorrentFile(FailedToAddTorrentFileEvent event) {
        log.debug("Send FailedToAddTorrentFilePayload to clients.");
        this.messagingTemplate.convertAndSend("/torrents", (MessagePayload)new FailedToAddTorrentFilePayload(event));
    }
}

