/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.services.corelistener;

import java.util.Map;
import javax.inject.Inject;
import org.araymond.joal.core.events.global.state.GlobalSeedStartedEvent;
import org.araymond.joal.core.events.global.state.GlobalSeedStoppedEvent;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.impl.global.state.GlobalSeedStartedPayload;
import org.araymond.joal.web.messages.outgoing.impl.global.state.GlobalSeedStoppedPayload;
import org.araymond.joal.web.services.JoalMessageSendingTemplate;
import org.araymond.joal.web.services.corelistener.WebEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@ConditionalOnWebUi
@Service
public class WebGlobalEventListener
extends WebEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebGlobalEventListener.class);

    @Inject
    public WebGlobalEventListener(JoalMessageSendingTemplate messagingTemplate) {
        super(messagingTemplate);
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void globalSeedStarted(GlobalSeedStartedEvent event) {
        log.debug("Send GlobalSeedStartedPayload to clients");
        String client = event.getBitTorrentClient().getHeaders().stream().filter(hdr -> "User-Agent".equalsIgnoreCase((String)hdr.getKey())).findFirst().map(Map.Entry::getValue).orElse("Unknown");
        this.messagingTemplate.convertAndSend("/global", (MessagePayload)new GlobalSeedStartedPayload(client));
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void globalSeedStopped(GlobalSeedStoppedEvent event) {
        log.debug("Send GlobalSeedStoppedPayload to clients");
        this.messagingTemplate.convertAndSend("/global", (MessagePayload)new GlobalSeedStoppedPayload());
    }
}

