/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.resources;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.araymond.joal.core.SeedManager;
import org.araymond.joal.core.events.announce.SuccessfullyAnnounceEvent;
import org.araymond.joal.core.events.config.ConfigHasBeenLoadedEvent;
import org.araymond.joal.core.events.config.ListOfClientFilesEvent;
import org.araymond.joal.core.events.speed.SeedingSpeedsHasChangedEvent;
import org.araymond.joal.core.events.torrent.files.TorrentFileAddedEvent;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.torrent.torrent.MockedTorrent;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.messages.incoming.config.Base64TorrentIncomingMessage;
import org.araymond.joal.web.messages.incoming.config.ConfigIncomingMessage;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.StompMessage;
import org.araymond.joal.web.messages.outgoing.impl.announce.SuccessfullyAnnouncePayload;
import org.araymond.joal.web.messages.outgoing.impl.config.ConfigHasBeenLoadedPayload;
import org.araymond.joal.web.messages.outgoing.impl.config.InvalidConfigPayload;
import org.araymond.joal.web.messages.outgoing.impl.config.ListOfClientFilesPayload;
import org.araymond.joal.web.messages.outgoing.impl.files.TorrentFileAddedPayload;
import org.araymond.joal.web.messages.outgoing.impl.global.state.GlobalSeedStartedPayload;
import org.araymond.joal.web.messages.outgoing.impl.global.state.GlobalSeedStoppedPayload;
import org.araymond.joal.web.messages.outgoing.impl.speed.SeedingSpeedHasChangedPayload;
import org.araymond.joal.web.services.JoalMessageSendingTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;

@ConditionalOnWebUi
@Controller
public class WebSocketController {
    private static final Logger log = LoggerFactory.getLogger(WebSocketController.class);
    private final SeedManager seedManager;
    private final JoalMessageSendingTemplate messageSendingTemplate;

    @Inject
    public WebSocketController(SeedManager seedManager, JoalMessageSendingTemplate messageSendingTemplate) {
        this.seedManager = seedManager;
        this.messageSendingTemplate = messageSendingTemplate;
    }

    @MessageMapping(value={"/config/save"})
    public void saveNewConf(ConfigIncomingMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("Client ask to save new conf {}", (Object)message.toString());
        }
        try {
            this.seedManager.saveNewConfiguration(message.toAppConfiguration());
        }
        catch (Exception e) {
            log.warn("Failed to save conf {}", (Object)message.toString(), (Object)e);
            this.messageSendingTemplate.convertAndSend("/config", (MessagePayload)new InvalidConfigPayload(e));
        }
    }

    @MessageMapping(value={"/global/start"})
    public void startStartSession() throws IOException {
        this.seedManager.startSeeding();
    }

    @MessageMapping(value={"/global/stop"})
    public void stopSeedSession() {
        this.seedManager.stop();
    }

    @MessageMapping(value={"/torrents/upload"})
    public void uploadTorrent(Base64TorrentIncomingMessage b64TorrentFile) throws IOException {
        byte[] bytes = Base64.decodeBase64((String)b64TorrentFile.getB64String());
        this.seedManager.saveTorrentToDisk(b64TorrentFile.getFileName(), bytes);
    }

    @MessageMapping(value={"/torrents/delete"})
    public void deleteTorrent(String torrentInfoHash) {
        this.seedManager.deleteTorrent(new InfoHash(torrentInfoHash.getBytes(MockedTorrent.BYTE_ENCODING)));
    }

    @SubscribeMapping(value={"/initialize-me"})
    public List<StompMessage> list() {
        LinkedList<StompMessage> events = new LinkedList<StompMessage>();
        events.add(StompMessage.wrap((MessagePayload)new ListOfClientFilesPayload(new ListOfClientFilesEvent(this.seedManager.listClientFiles()))));
        events.addFirst(StompMessage.wrap((MessagePayload)new ConfigHasBeenLoadedPayload(new ConfigHasBeenLoadedEvent(this.seedManager.getCurrentConfig()))));
        this.seedManager.getTorrentFiles().forEach(torrent -> events.addFirst(StompMessage.wrap((MessagePayload)new TorrentFileAddedPayload(new TorrentFileAddedEvent(torrent)))));
        if (this.seedManager.isSeeding()) {
            events.addFirst(StompMessage.wrap((MessagePayload)new GlobalSeedStartedPayload(this.seedManager.getCurrentEmulatedClient())));
        } else {
            events.addFirst(StompMessage.wrap((MessagePayload)new GlobalSeedStoppedPayload()));
        }
        Map speedMap = this.seedManager.getSpeedMap();
        if (!speedMap.isEmpty()) {
            events.addFirst(StompMessage.wrap((MessagePayload)new SeedingSpeedHasChangedPayload(new SeedingSpeedsHasChangedEvent(speedMap))));
        }
        this.seedManager.getCurrentlySeedingAnnouncers().forEach(a -> events.addFirst(StompMessage.wrap((MessagePayload)new SuccessfullyAnnouncePayload(new SuccessfullyAnnounceEvent(a, TrackerMessage.AnnounceRequestMessage.RequestEvent.STARTED)))));
        return events;
    }
}

