/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.messages.incoming.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.araymond.joal.core.config.AppConfiguration;
import org.araymond.joal.core.config.AppConfigurationIntegrityException;

public class ConfigIncomingMessage {
    private final Long minUploadRate;
    private final Long maxUploadRate;
    private final Integer simultaneousSeed;
    private final String client;
    private final boolean keepTorrentWithZeroLeechers;
    private final Float uploadRatioTarget;

    @JsonCreator
    ConfigIncomingMessage(@JsonProperty(value="minUploadRate", required=true) Long minUploadRate, @JsonProperty(value="maxUploadRate", required=true) Long maxUploadRate, @JsonProperty(value="simultaneousSeed", required=true) Integer simultaneousSeed, @JsonProperty(value="client", required=true) String client, @JsonProperty(value="keepTorrentWithZeroLeechers", required=true) boolean keepTorrentWithZeroLeechers, @JsonProperty(value="uploadRatioTarget", required=false) Float uploadRatioTarget) {
        this.minUploadRate = minUploadRate;
        this.maxUploadRate = maxUploadRate;
        this.simultaneousSeed = simultaneousSeed;
        this.client = client;
        this.keepTorrentWithZeroLeechers = keepTorrentWithZeroLeechers;
        this.uploadRatioTarget = Float.valueOf(uploadRatioTarget == null ? -1.0f : uploadRatioTarget.floatValue());
    }

    public AppConfiguration toAppConfiguration() throws AppConfigurationIntegrityException {
        return new AppConfiguration(this.minUploadRate.longValue(), this.maxUploadRate.longValue(), this.simultaneousSeed.intValue(), this.client, this.keepTorrentWithZeroLeechers, this.uploadRatioTarget);
    }

    public Long getMinUploadRate() {
        return this.minUploadRate;
    }

    public Long getMaxUploadRate() {
        return this.maxUploadRate;
    }

    public Integer getSimultaneousSeed() {
        return this.simultaneousSeed;
    }

    public String getClient() {
        return this.client;
    }

    public boolean isKeepTorrentWithZeroLeechers() {
        return this.keepTorrentWithZeroLeechers;
    }

    public Float getUploadRatioTarget() {
        return this.uploadRatioTarget;
    }

    public String toString() {
        return "ConfigIncomingMessage(minUploadRate=" + this.getMinUploadRate() + ", maxUploadRate=" + this.getMaxUploadRate() + ", simultaneousSeed=" + this.getSimultaneousSeed() + ", client=" + this.getClient() + ", keepTorrentWithZeroLeechers=" + this.isKeepTorrentWithZeroLeechers() + ", uploadRatioTarget=" + this.getUploadRatioTarget() + ")";
    }
}

