/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.config.security.websocket.interceptor;

import java.security.Principal;
import javax.inject.Inject;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.config.security.websocket.services.WebSocketAuthenticatorService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@ConditionalOnWebUi
@Component
public class AuthChannelInterceptorAdapter
implements ChannelInterceptor {
    static final String USERNAME_HEADER = "X-Joal-Username";
    static final String TOKEN_HEADER = "X-Joal-Auth-Token";
    private final WebSocketAuthenticatorService webSocketAuthenticatorService;

    @Inject
    public AuthChannelInterceptorAdapter(WebSocketAuthenticatorService webSocketAuthenticatorService) {
        this.webSocketAuthenticatorService = webSocketAuthenticatorService;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) throws AuthenticationException {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        if (StompCommand.CONNECT == accessor.getCommand()) {
            String username = accessor.getFirstNativeHeader(USERNAME_HEADER);
            String authToken = accessor.getFirstNativeHeader(TOKEN_HEADER);
            UsernamePasswordAuthenticationToken user = this.webSocketAuthenticatorService.getAuthenticatedOrFail((CharSequence)username, (CharSequence)authToken);
            accessor.setUser((Principal)user);
        }
        return message;
    }
}

