/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.tracker;

import com.google.common.collect.Iterators;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.araymond.joal.core.ttorrent.client.announcer.tracker.NoMoreUriAvailableException;

public class TrackerClientUriProvider {
    private final Iterator<URI> addressIterator;
    private URI currentURI = null;

    public TrackerClientUriProvider(List<URI> trackersURI) {
        List trackers = trackersURI.stream().filter(uri -> uri.getScheme().startsWith("http")).collect(Collectors.toList());
        if (trackers.isEmpty()) {
            throw new NoMoreUriAvailableException("No valid http trackers provided");
        }
        this.addressIterator = Iterators.cycle(trackers);
        this.currentURI = (URI)this.addressIterator.next();
    }

    URI get() {
        return this.currentURI;
    }

    void deleteCurrentAndMoveToNext() throws NoMoreUriAvailableException {
        this.addressIterator.remove();
        this.moveToNext();
    }

    void moveToNext() throws NoMoreUriAvailableException {
        if (!this.addressIterator.hasNext()) {
            throw new NoMoreUriAvailableException("No more valid tracker URIs left");
        }
        this.currentURI = (URI)this.addressIterator.next();
    }
}

