/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.response;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.araymond.joal.core.ttorrent.client.DelayQueue;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnounceRequest;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnounceReEnqueuer
implements AnnounceResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnounceReEnqueuer.class);
    private final DelayQueue<AnnounceRequest> delayQueue;

    public void onAnnouncerWillAnnounce(Announcer announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
    }

    public void onAnnounceStartSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Enqueue torrent {} in regular queue", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createRegular((Announcer)announcer), result.getInterval(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public void onAnnounceStartFails(Announcer announcer, Throwable throwable) {
        log.debug("Enqueue torrent {} in start queue once again (because it failed)", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createStart((Announcer)announcer), announcer.getLastKnownInterval(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public void onAnnounceRegularSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Enqueue torrent {} in regular queue", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createRegular((Announcer)announcer), result.getInterval(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public void onAnnounceRegularFails(Announcer announcer, Throwable throwable) {
        log.debug("Enqueue torrent {} in regular queue once again (because it failed)", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createRegular((Announcer)announcer), announcer.getLastKnownInterval(), (TemporalUnit)ChronoUnit.SECONDS);
    }

    public void onAnnounceStopSuccess(Announcer announcer, SuccessAnnounceResponse result) {
    }

    public void onAnnounceStopFails(Announcer announcer, Throwable throwable) {
        log.debug("Enqueue torrent {} in stop queue once again (because it failed)", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.delayQueue.addOrReplace((DelayQueue.InfoHashAble)AnnounceRequest.createStop((Announcer)announcer), 0, (TemporalUnit)ChronoUnit.SECONDS);
    }

    public void onTooManyAnnounceFailedInARow(Announcer announcer, TooManyAnnouncesFailedInARowException e) {
    }

    public AnnounceReEnqueuer(DelayQueue<AnnounceRequest> delayQueue) {
        this.delayQueue = delayQueue;
    }
}

