/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.response;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import org.araymond.joal.core.events.announce.FailedToAnnounceEvent;
import org.araymond.joal.core.events.announce.SuccessfullyAnnounceEvent;
import org.araymond.joal.core.events.announce.TooManyAnnouncesFailedEvent;
import org.araymond.joal.core.events.announce.WillAnnounceEvent;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFacade;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class AnnounceEventPublisher
implements AnnounceResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnounceEventPublisher.class);
    private final ApplicationEventPublisher eventPublisher;

    public void onAnnouncerWillAnnounce(Announcer announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        log.debug("Publish WillAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new WillAnnounceEvent((AnnouncerFacade)announcer, event));
    }

    public void onAnnounceStartSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Publish SuccessfullyAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new SuccessfullyAnnounceEvent((AnnouncerFacade)announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent.STARTED));
    }

    public void onAnnounceStartFails(Announcer announcer, Throwable throwable) {
        log.debug("Publish FailedToAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new FailedToAnnounceEvent((AnnouncerFacade)announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent.STARTED, throwable.getMessage()));
    }

    public void onAnnounceRegularSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Publish SuccessfullyAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new SuccessfullyAnnounceEvent((AnnouncerFacade)announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent.NONE));
    }

    public void onAnnounceRegularFails(Announcer announcer, Throwable throwable) {
        log.debug("Publish FailedToAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new FailedToAnnounceEvent((AnnouncerFacade)announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent.NONE, throwable.getMessage()));
    }

    public void onAnnounceStopSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Publish SuccessfullyAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new SuccessfullyAnnounceEvent((AnnouncerFacade)announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent.STOPPED));
    }

    public void onAnnounceStopFails(Announcer announcer, Throwable throwable) {
        log.debug("Publish FailedToAnnounceEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new FailedToAnnounceEvent((AnnouncerFacade)announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent.STOPPED, throwable.getMessage()));
    }

    public void onTooManyAnnounceFailedInARow(Announcer announcer, TooManyAnnouncesFailedInARowException e) {
        log.debug("Publish TooManyAnnouncesFailedEvent event for [{}]", (Object)announcer.getTorrentInfoHash().getHumanReadable());
        this.eventPublisher.publishEvent((Object)new TooManyAnnouncesFailedEvent((AnnouncerFacade)announcer));
    }

    public AnnounceEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

