/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client;

import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.araymond.joal.core.ttorrent.client.DelayQueue;

public class DelayQueue<T extends InfoHashAble> {
    private final Lock lock = new ReentrantLock();
    private final Queue<IntervalAware<T>> queue = new PriorityQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrReplace(T item, int interval, TemporalUnit unit) {
        IntervalAware intervalAware = new IntervalAware(item, LocalDateTime.now().plus(interval, unit));
        this.lock.lock();
        try {
            this.queue.removeIf(this.infoHashEquals(item));
            this.queue.add(intervalAware);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAvailables() {
        this.lock.lock();
        try {
            IntervalAware first = (IntervalAware)this.queue.peek();
            LocalDateTime now = LocalDateTime.now();
            if (first == null || first.releaseAt.isAfter(now)) {
                List list = Collections.emptyList();
                return list;
            }
            ArrayList<InfoHashAble> timedOutItems = new ArrayList<InfoHashAble>();
            do {
                timedOutItems.add((InfoHashAble)((IntervalAware)this.queue.poll()).getItem());
            } while (!this.queue.isEmpty() && !((IntervalAware)this.queue.peek()).releaseAt.isAfter(now));
            ArrayList<InfoHashAble> arrayList = timedOutItems;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Predicate<IntervalAware<T>> infoHashEquals(T item) {
        return i -> ((InfoHashAble)i.getItem()).getInfoHash().equals((Object)item.getInfoHash());
    }

    public void remove(T itemToRemove) {
        this.lock.lock();
        try {
            this.queue.removeIf(this.infoHashEquals(itemToRemove));
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> drainAll() {
        this.lock.lock();
        try {
            ArrayList<InfoHashAble> items = new ArrayList<InfoHashAble>(this.queue.size());
            while (!this.queue.isEmpty()) {
                items.add((InfoHashAble)((IntervalAware)this.queue.poll()).getItem());
            }
            ArrayList<InfoHashAble> arrayList = items;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }
}

