/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    public static final int PORT_RANGE_START = 49152;
    public static final int PORT_RANGE_END = 65534;
    private ServerSocketChannel channel;
    private InetAddress ipAddress;
    private Thread ipFetcherThread;
    private static final String[] IP_PROVIDERS = new String[]{"http://whatismyip.akamai.com", "http://ipecho.net/plain", "http://ip.tyk.nu/", "http://l2.io/ip", "http://ident.me/", "http://icanhazip.com/", "https://api.ipify.org", "https://ipinfo.io/ip", "https://checkip.amazonaws.com"};

    public int getPort() {
        return this.channel.socket().getLocalPort();
    }

    public void start() throws IOException {
        this.channel = this.bindToPort();
        log.info("Listening for incoming peer connections on port {}", (Object)this.getPort());
        this.ipAddress = this.fetchIp();
        log.info("IP reported to tracker will be: {}", (Object)this.getIpAddress().getHostAddress());
        this.ipFetcherThread = new Thread(() -> {
            while (this.ipFetcherThread == null || !this.ipFetcherThread.isInterrupted()) {
                try {
                    TimeUnit.MINUTES.sleep(90L);
                    this.ipAddress = this.fetchIp();
                }
                catch (UnknownHostException e) {
                    log.warn("Failed to fetch external IP", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.info("IP fetcher thread has been stopped");
                }
            }
        });
        this.ipFetcherThread.start();
    }

    @VisibleForTesting
    InetAddress readIpFromProvider(String providerUrl) throws IOException {
        URLConnection urlConnection = new URL(providerUrl).openConnection();
        urlConnection.setRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36");
        try {
            InetAddress inetAddress;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charsets.UTF_8));){
                inetAddress = InetAddress.getByName(in.readLine());
            }
            return inetAddress;
        }
        finally {
            InputStream errStream = ((HttpURLConnection)urlConnection).getErrorStream();
            try {
                if (errStream != null) {
                    errStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @VisibleForTesting
    Optional<InetAddress> tryToFetchFromProviders() {
        List<String> shuffledList = Arrays.asList(IP_PROVIDERS);
        Collections.shuffle(shuffledList);
        for (String ipProviderUrl : shuffledList) {
            log.info("Fetching ip from {}", (Object)ipProviderUrl);
            try {
                return Optional.of(this.readIpFromProvider(ipProviderUrl));
            }
            catch (IOException e) {
                log.warn("Failed to fetch IP from [" + ipProviderUrl + "]", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    InetAddress fetchIp() throws UnknownHostException {
        Optional ip = this.tryToFetchFromProviders();
        if (ip.isPresent()) {
            log.info("Successfully fetched public IP address: [{}]", (Object)((InetAddress)ip.get()).getHostAddress());
            return (InetAddress)ip.get();
        }
        if (this.ipAddress != null) {
            log.warn("Failed to fetch public IP address, reusing last known IP address: [{}]", (Object)this.ipAddress.getHostAddress());
            return this.ipAddress;
        }
        log.warn("Failed to fetch public IP address, fallback to localhost");
        return InetAddress.getLocalHost();
    }

    @VisibleForTesting
    ServerSocketChannel bindToPort() throws IOException {
        ServerSocketChannel channel = null;
        for (int port = 49152; port <= 65534; ++port) {
            InetSocketAddress tryAddress = new InetSocketAddress(port);
            try {
                channel = ServerSocketChannel.open();
                channel.socket().bind(tryAddress);
                channel.configureBlocking(false);
                break;
            }
            catch (IOException ioe) {
                log.warn("Could not bind to port {}: {}", (Object)tryAddress.getPort(), (Object)ioe.getMessage());
                log.warn("trying next port...");
                try {
                    if (channel == null) continue;
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (channel == null || !channel.socket().isBound()) {
            throw new IOException("No available port for the BitTorrent client!");
        }
        return channel;
    }

    public void close() {
        log.debug("Closing ConnectionHandler...");
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            log.warn("ConnectionHandler channel has failed to release channel, but the shutdown will proceed", (Throwable)e);
        }
        finally {
            this.channel = null;
        }
        try {
            if (this.ipFetcherThread != null) {
                this.ipFetcherThread.interrupt();
            }
        }
        finally {
            this.ipFetcherThread = null;
        }
        log.debug("ConnectionHandler closed");
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }
}

