/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.torrent.watcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.araymond.joal.core.SeedManager;
import org.araymond.joal.core.exception.NoMoreTorrentsFileAvailableException;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.torrent.torrent.MockedTorrent;
import org.araymond.joal.core.torrent.watcher.TorrentFileChangeAware;
import org.araymond.joal.core.torrent.watcher.TorrentFileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentFileProvider
extends FileAlterationListenerAdaptor {
    private static final Logger log = LoggerFactory.getLogger(TorrentFileProvider.class);
    private final TorrentFileWatcher watcher;
    private final Map<File, MockedTorrent> torrentFiles = Collections.synchronizedMap(new HashMap());
    private final Set<TorrentFileChangeAware> torrentFileChangeListeners;
    private final Path archiveFolder;

    public TorrentFileProvider(SeedManager.JoalFoldersPath joalFoldersPath) throws FileNotFoundException {
        Path torrentsDir = joalFoldersPath.getTorrentsDirPath();
        if (!Files.isDirectory(torrentsDir, new LinkOption[0])) {
            log.error("Folder [{}] does not exist", (Object)torrentsDir.toAbsolutePath());
            throw new FileNotFoundException(String.format("Torrent folder [%s] not found", torrentsDir.toAbsolutePath()));
        }
        this.archiveFolder = joalFoldersPath.getTorrentArchiveDirPath();
        this.watcher = new TorrentFileWatcher((FileAlterationListener)this, torrentsDir);
        this.torrentFileChangeListeners = new HashSet();
    }

    public void start() {
        this.init();
        this.watcher.start();
    }

    @VisibleForTesting
    void init() {
        if (!Files.isDirectory(this.archiveFolder, new LinkOption[0])) {
            if (Files.exists(this.archiveFolder, new LinkOption[0])) {
                String errMsg = "Archive folder exists, but is not a directory";
                log.error(errMsg);
                throw new IllegalStateException(errMsg);
            }
            try {
                Files.createDirectory(this.archiveFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                String errMsg = "Failed to create archive folder";
                log.error(errMsg, (Throwable)e);
                throw new IllegalStateException(errMsg, e);
            }
        }
    }

    public void stop() {
        this.watcher.stop();
        this.torrentFiles.clear();
    }

    public void onFileDelete(File file) {
        Optional.ofNullable((MockedTorrent)this.torrentFiles.remove(file)).ifPresent(removedTorrent -> {
            log.info("Torrent file deleting detected, hot deleted file [{}]", (Object)file.getAbsolutePath());
            this.torrentFileChangeListeners.forEach(listener -> listener.onTorrentFileRemoved(removedTorrent));
        });
    }

    public void onFileCreate(File file) {
        log.info("Torrent file addition detected, hot creating file [{}]", (Object)file.getAbsolutePath());
        try {
            MockedTorrent torrent = MockedTorrent.fromFile((File)file);
            this.torrentFiles.put(file, torrent);
            this.torrentFileChangeListeners.forEach(listener -> listener.onTorrentFileAdded(torrent));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.warn("Failed to read file [{}], moved to archive folder: {}", (Object)file.getAbsolutePath(), (Object)e);
            this.moveToArchiveFolder(file);
        }
        catch (Exception e) {
            log.error("Unexpected exception was caught for file [{}], moved to archive folder: {}", (Object)file.getAbsolutePath(), (Object)e);
            this.moveToArchiveFolder(file);
        }
    }

    public void onFileChange(File file) {
        log.info("Torrent file change detected, hot reloading file [{}]", (Object)file.getAbsolutePath());
        this.onFileDelete(file);
        this.onFileCreate(file);
    }

    public void registerListener(TorrentFileChangeAware listener) {
        this.torrentFileChangeListeners.add(listener);
    }

    public void unRegisterListener(TorrentFileChangeAware listener) {
        this.torrentFileChangeListeners.remove(listener);
    }

    public MockedTorrent getTorrentNotIn(Collection<InfoHash> unwantedTorrents) throws NoMoreTorrentsFileAvailableException {
        Preconditions.checkNotNull(unwantedTorrents, (Object)"unwantedTorrents cannot be null");
        return (MockedTorrent)this.torrentFiles.values().stream().filter(torrent -> !unwantedTorrents.contains(torrent.getTorrentInfoHash())).collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
            Collections.shuffle(collected);
            return collected.stream();
        })).findAny().orElseThrow(() -> new NoMoreTorrentsFileAvailableException("No more torrent files available"));
    }

    void moveToArchiveFolder(File torrentFile) {
        if (torrentFile == null || !torrentFile.exists()) {
            return;
        }
        this.onFileDelete(torrentFile);
        try {
            Path moveTarget = this.archiveFolder.resolve(torrentFile.getName());
            Files.move(torrentFile.toPath(), moveTarget, StandardCopyOption.REPLACE_EXISTING);
            log.info("Successfully moved file [{}] to archive folder", (Object)torrentFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Failed to archive file [{}], the file won't be used anymore for the current session, but it remains in the folder", (Object)torrentFile.getAbsolutePath());
        }
    }

    public void moveToArchiveFolder(InfoHash infoHash) {
        this.torrentFiles.entrySet().stream().filter(entry -> ((MockedTorrent)entry.getValue()).getTorrentInfoHash().equals((Object)infoHash)).findAny().map(Map.Entry::getKey).ifPresentOrElse(arg_0 -> this.moveToArchiveFolder(arg_0), () -> log.warn("Cannot move torrent [{}] to archive folder. Torrent file seems not to be registered in TorrentFileProvider", (Object)infoHash));
    }

    public int getTorrentCount() {
        return this.torrentFiles.size();
    }

    public List<MockedTorrent> getTorrentFiles() {
        return new ArrayList<MockedTorrent>(this.torrentFiles.values());
    }
}

