/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.peerid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.araymond.joal.core.client.emulated.TorrentClientConfigIntegrityException;
import org.araymond.joal.core.client.emulated.generator.peerid.PeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.generation.PeerIdAlgorithm;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class TimedRefreshPeerIdGenerator
extends PeerIdGenerator {
    @VisibleForTesting
    LocalDateTime lastGeneration;
    private String peerId;
    private final int refreshEvery;

    @JsonCreator
    TimedRefreshPeerIdGenerator(@JsonProperty(value="refreshEvery", required=true) int refreshEvery, @JsonProperty(value="algorithm", required=true) PeerIdAlgorithm algorithm, @JsonProperty(value="shouldUrlEncode", required=true) boolean isUrlEncoded) {
        super(algorithm, isUrlEncoded);
        if (refreshEvery < 1) {
            throw new TorrentClientConfigIntegrityException("refreshEvery must be greater than 0");
        }
        this.refreshEvery = refreshEvery;
    }

    public String getPeerId(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        if (this.shouldRegeneratePeerId()) {
            this.lastGeneration = LocalDateTime.now();
            this.peerId = super.generatePeerId();
        }
        return this.peerId;
    }

    private boolean shouldRegeneratePeerId() {
        return this.lastGeneration == null || ChronoUnit.SECONDS.between(this.lastGeneration, LocalDateTime.now()) >= (long)this.refreshEvery;
    }

    public int getRefreshEvery() {
        return this.refreshEvery;
    }
}

