/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.key.algorithm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.ThreadLocalRandom;
import org.araymond.joal.core.client.emulated.TorrentClientConfigIntegrityException;
import org.araymond.joal.core.client.emulated.generator.key.algorithm.KeyAlgorithm;

public class DigitRangeTransformedToHexWithoutLeadingZeroAlgorithm
implements KeyAlgorithm {
    private final long inclusiveLowerBound;
    private final long inclusiveUpperBound;

    public DigitRangeTransformedToHexWithoutLeadingZeroAlgorithm(@JsonProperty(value="inclusiveLowerBound", required=true) long inclusiveLowerBound, @JsonProperty(value="inclusiveUpperBound", required=true) long inclusiveUpperBound) {
        if (inclusiveUpperBound < inclusiveLowerBound) {
            throw new TorrentClientConfigIntegrityException("inclusiveUpperBound must be greater than inclusiveLowerBound");
        }
        this.inclusiveLowerBound = inclusiveLowerBound;
        this.inclusiveUpperBound = inclusiveUpperBound;
    }

    long getRandomDigitBetween(Long minInclusive, long maxInclusive) {
        return ThreadLocalRandom.current().nextLong(minInclusive, maxInclusive + 1L);
    }

    public String generate() {
        long randomDigit = this.getRandomDigitBetween(Long.valueOf(this.inclusiveLowerBound), this.inclusiveUpperBound);
        return Long.toHexString(randomDigit);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DigitRangeTransformedToHexWithoutLeadingZeroAlgorithm)) {
            return false;
        }
        DigitRangeTransformedToHexWithoutLeadingZeroAlgorithm other = (DigitRangeTransformedToHexWithoutLeadingZeroAlgorithm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.inclusiveLowerBound != other.inclusiveLowerBound) {
            return false;
        }
        return this.inclusiveUpperBound == other.inclusiveUpperBound;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DigitRangeTransformedToHexWithoutLeadingZeroAlgorithm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $inclusiveLowerBound = this.inclusiveLowerBound;
        result = result * 59 + (int)($inclusiveLowerBound >>> 32 ^ $inclusiveLowerBound);
        long $inclusiveUpperBound = this.inclusiveUpperBound;
        result = result * 59 + (int)($inclusiveUpperBound >>> 32 ^ $inclusiveUpperBound);
        return result;
    }
}

