/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.araymond.joal.core.client.emulated.TorrentClientConfigIntegrityException;
import org.araymond.joal.core.client.emulated.generator.key.KeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.algorithm.KeyAlgorithm;
import org.araymond.joal.core.client.emulated.utils.Casing;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class TimedRefreshKeyGenerator
extends KeyGenerator {
    @VisibleForTesting
    LocalDateTime lastGeneration;
    @JsonIgnore
    private String key;
    private final int refreshEvery;

    @JsonCreator
    TimedRefreshKeyGenerator(@JsonProperty(value="refreshEvery", required=true) int refreshEvery, @JsonProperty(value="algorithm", required=true) KeyAlgorithm algorithm, @JsonProperty(value="keyCase", required=true) Casing keyCase) {
        super(algorithm, keyCase);
        if (refreshEvery < 1) {
            throw new TorrentClientConfigIntegrityException("refreshEvery must be greater than 0");
        }
        this.refreshEvery = refreshEvery;
    }

    public String getKey(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        if (this.shouldRegenerateKey()) {
            this.lastGeneration = LocalDateTime.now();
            this.key = super.generateKey();
        }
        return this.key;
    }

    boolean shouldRegenerateKey() {
        return this.lastGeneration == null || ChronoUnit.SECONDS.between(this.lastGeneration, LocalDateTime.now()) >= (long)this.refreshEvery;
    }

    void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public int getRefreshEvery() {
        return this.refreshEvery;
    }
}

