/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.bandwith.weight;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.araymond.joal.core.bandwith.Peers;
import org.araymond.joal.core.bandwith.weight.PeersAwareWeightCalculator;

public class WeightHolder<E> {
    private final Lock lock = new ReentrantLock();
    private final Map<E, Double> weightMap = new HashMap();
    private final PeersAwareWeightCalculator weightCalculator;
    private double totalWeight;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdate(E item, Peers peers) {
        double weight = this.weightCalculator.calculate(peers);
        this.lock.lock();
        try {
            Optional.ofNullable(this.weightMap.put(item, weight)).ifPresentOrElse(previousWeight -> {
                this.totalWeight = this.totalWeight - previousWeight + weight;
            }, () -> this.totalWeight += weight);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(E item) {
        this.lock.lock();
        try {
            Optional.ofNullable((Double)this.weightMap.remove(item)).ifPresent(w -> this.totalWeight -= w.doubleValue());
        }
        finally {
            this.lock.unlock();
        }
    }

    public double getWeightFor(E item) {
        return this.weightMap.getOrDefault(item, 0.0);
    }

    public WeightHolder(PeersAwareWeightCalculator weightCalculator) {
        this.weightCalculator = weightCalculator;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }
}

