/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.bandwith;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.araymond.joal.core.bandwith.BandwidthDispatcherFacade;
import org.araymond.joal.core.bandwith.Peers;
import org.araymond.joal.core.bandwith.RandomSpeedProvider;
import org.araymond.joal.core.bandwith.Speed;
import org.araymond.joal.core.bandwith.SpeedChangedListener;
import org.araymond.joal.core.bandwith.TorrentSeedStats;
import org.araymond.joal.core.bandwith.weight.PeersAwareWeightCalculator;
import org.araymond.joal.core.bandwith.weight.WeightHolder;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandwidthDispatcher
implements BandwidthDispatcherFacade,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(BandwidthDispatcher.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final WeightHolder<InfoHash> weightHolder = new WeightHolder(new PeersAwareWeightCalculator());
    private final Map<InfoHash, TorrentSeedStats> torrentsSeedStats = new HashMap();
    private final Map<InfoHash, Speed> speedMap = new HashMap();
    private SpeedChangedListener speedChangedListener;
    private int threadLoopCounter;
    private volatile boolean stop;
    private Thread thread;
    private final int threadPauseIntervalMs;
    private final RandomSpeedProvider randomSpeedProvider;
    private static final long TWENTY_MINS_MS = TimeUnit.MINUTES.toMillis(20L);

    public void setSpeedListener(SpeedChangedListener speedListener) {
        this.speedChangedListener = speedListener;
    }

    public TorrentSeedStats getSeedStatForTorrent(InfoHash infoHash) {
        return (TorrentSeedStats)ObjectUtils.getIfNull((Object)((TorrentSeedStats)this.torrentsSeedStats.get(infoHash)), TorrentSeedStats::new);
    }

    public Map<InfoHash, Speed> getSpeedMap() {
        try {
            this.lock.readLock().lock();
            HashMap<InfoHash, Speed> hashMap = new HashMap<InfoHash, Speed>(this.speedMap);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void start() {
        this.stop = false;
        this.thread = new Thread((Runnable)this);
        this.thread.setName("bandwidth-dispatcher");
        this.thread.start();
    }

    public void stop() {
        this.stop = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            while (!this.stop) {
                TimeUnit.MILLISECONDS.sleep(this.threadPauseIntervalMs);
                ++this.threadLoopCounter;
                if ((long)this.threadLoopCounter == TWENTY_MINS_MS / (long)this.threadPauseIntervalMs) {
                    this.refreshCurrentBandwidth();
                    this.threadLoopCounter = 0;
                }
                this.lock.readLock().lock();
                HashSet seedStatsView = new HashSet(this.torrentsSeedStats.entrySet());
                this.lock.readLock().unlock();
                seedStatsView.forEach(entry -> {
                    long speedInBytesPerSecond = Optional.ofNullable((Speed)this.speedMap.get(entry.getKey())).map(Speed::getBytesPerSecond).orElse(0L);
                    ((TorrentSeedStats)entry.getValue()).addUploaded(speedInBytesPerSecond * (long)this.threadPauseIntervalMs / 1000L);
                });
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTorrentPeers(InfoHash infoHash, int seeders, int leechers) {
        log.debug("Updating Peers stats for {}", (Object)infoHash.getHumanReadable());
        this.lock.writeLock().lock();
        try {
            this.weightHolder.addOrUpdate((Object)infoHash, new Peers(seeders, leechers));
            this.recomputeSpeeds();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void registerTorrent(InfoHash infoHash) {
        log.debug("{} has been added to bandwidth dispatcher", (Object)infoHash.getHumanReadable());
        this.lock.writeLock().lock();
        try {
            this.torrentsSeedStats.put(infoHash, new TorrentSeedStats());
            this.speedMap.put(infoHash, new Speed(0L));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unregisterTorrent(InfoHash infoHash) {
        log.debug("{} has been removed from bandwidth dispatcher", (Object)infoHash.getHumanReadable());
        this.lock.writeLock().lock();
        try {
            this.weightHolder.remove((Object)infoHash);
            this.torrentsSeedStats.remove(infoHash);
            this.speedMap.remove(infoHash);
            this.recomputeSpeeds();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    void refreshCurrentBandwidth() {
        log.debug("Refreshing global bandwidth");
        this.lock.writeLock().lock();
        try {
            this.randomSpeedProvider.refresh();
            this.recomputeSpeeds();
            if (log.isDebugEnabled()) {
                log.debug("Global bandwidth refreshed, new value is {}/s", (Object)FileUtils.byteCountToDisplaySize((long)this.randomSpeedProvider.getCurrentSpeed()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    void recomputeSpeeds() {
        log.debug("Refreshing all torrents speeds");
        this.torrentsSeedStats.keySet().forEach(infohash -> this.speedMap.compute(infohash, (hash, speed) -> {
            if (speed == null) {
                return new Speed(0L);
            }
            double percentOfSpeedAssigned = this.weightHolder.getTotalWeight() == 0.0 ? 0.0 : this.weightHolder.getWeightFor(infohash) / this.weightHolder.getTotalWeight();
            speed.setBytesPerSecond((long)((double)this.randomSpeedProvider.getCurrentSpeed() * percentOfSpeedAssigned));
            return speed;
        }));
        if (this.speedChangedListener != null) {
            this.speedChangedListener.speedsHasChanged(new HashMap(this.speedMap));
        }
        if (log.isDebugEnabled() && !this.speedMap.isEmpty()) {
            StringBuilder sb = new StringBuilder("All torrents speeds have been refreshed:\n");
            double totalWeight = this.weightHolder.getTotalWeight();
            this.speedMap.forEach((infoHash, speed) -> {
                String humanReadableSpeed = FileUtils.byteCountToDisplaySize((long)speed.getBytesPerSecond());
                double torrentWeight = this.weightHolder.getWeightFor(infoHash);
                double weightInPercent = torrentWeight > 0.0 ? totalWeight / torrentWeight * 100.0 : 0.0;
                sb.append("      ").append(infoHash.getHumanReadable()).append(":").append("\n          ").append("current speed: ").append(humanReadableSpeed).append("/s").append("\n          ").append("overall upload: ").append(FileUtils.byteCountToDisplaySize((long)((TorrentSeedStats)this.torrentsSeedStats.get(infoHash)).getUploaded())).append("\n          ").append("weight: ").append(weightInPercent).append("% (").append(torrentWeight).append(" out of ").append(totalWeight).append(")").append("\n");
            });
            sb.setLength(sb.length() - 1);
            log.debug(sb.toString());
        }
    }

    public BandwidthDispatcher(int threadPauseIntervalMs, RandomSpeedProvider randomSpeedProvider) {
        this.threadPauseIntervalMs = threadPauseIntervalMs;
        this.randomSpeedProvider = randomSpeedProvider;
    }
}

