/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.config.security;

import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@ConditionalOnWebUi
@EnableWebSecurity
@Configuration
public class WebSecurityConfig {
    private final String pathPrefix;
    private final boolean shouldDisableFrameOptions;

    public WebSecurityConfig(@Value(value="${joal.ui.path.prefix}") String pathPrefix, @Value(value="${joal.iframe.enabled:false}") boolean shouldDisableFrameOptions) {
        this.pathPrefix = pathPrefix;
        this.shouldDisableFrameOptions = shouldDisableFrameOptions;
    }

    @Bean
    SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        if (this.shouldDisableFrameOptions) {
            http.headers().frameOptions().disable();
        }
        return (SecurityFilterChain)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.httpBasic().disable()).formLogin().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/" + this.pathPrefix})).permitAll().antMatchers(new String[]{"/" + this.pathPrefix + "/ui/**"})).permitAll().anyRequest()).denyAll().and()).build();
    }

    @Bean
    public InMemoryUserDetailsManager userDetailsService() {
        return new InMemoryUserDetailsManager();
    }
}

