/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.config.obfuscation;

import javax.servlet.Servlet;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

@ConditionalOnWebUi
@Configuration
public class EndpointObfuscatorConfiguration {
    private final String pathPrefix;

    public EndpointObfuscatorConfiguration(@Value(value="${joal.ui.path.prefix}") String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    @Bean
    public ServletRegistrationBean obfuscatedDispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        AnnotationConfigWebApplicationContext applicationContext = new AnnotationConfigWebApplicationContext();
        dispatcherServlet.setApplicationContext((ApplicationContext)applicationContext);
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)dispatcherServlet, new String[]{"/" + this.pathPrefix + "/*"});
        servletRegistrationBean.setName("joal");
        return servletRegistrationBean;
    }
}

