/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.tracker;

import com.google.common.annotations.VisibleForTesting;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.tracker.NoMoreUriAvailableException;
import org.araymond.joal.core.ttorrent.client.announcer.tracker.TrackerClientUriProvider;

public class TrackerClient {
    private final TrackerClientUriProvider trackerClientUriProvider;
    private final ResponseHandler<TrackerMessage> trackerResponseHandler;
    private final HttpClient httpClient;

    public SuccessAnnounceResponse announce(String requestQuery, Iterable<Map.Entry<String, String>> headers) throws AnnounceException {
        TrackerMessage responseMessage;
        URI baseUri = this.trackerClientUriProvider.get();
        try {
            responseMessage = this.makeCallAndGetResponseAsByteBuffer(baseUri, requestQuery, headers);
            if (responseMessage instanceof TrackerMessage.ErrorMessage) {
                TrackerMessage.ErrorMessage error = (TrackerMessage.ErrorMessage)responseMessage;
                throw new AnnounceException(baseUri + ": " + error.getReason());
            }
        }
        catch (AnnounceException e) {
            try {
                this.trackerClientUriProvider.moveToNext();
            }
            catch (NoMoreUriAvailableException e1) {
                throw new AnnounceException("No more valid tracker for torrent", (Throwable)e1);
            }
            throw new AnnounceException(e.getMessage(), (Throwable)e);
        }
        if (!(responseMessage instanceof TrackerMessage.AnnounceResponseMessage)) {
            throw new AnnounceException("Unexpected tracker message type [" + responseMessage.getType().name() + "]!");
        }
        TrackerMessage.AnnounceResponseMessage announceResponseMessage = (TrackerMessage.AnnounceResponseMessage)responseMessage;
        int interval = announceResponseMessage.getInterval();
        int seeders = Math.max(0, announceResponseMessage.getComplete() - 1);
        int leechers = announceResponseMessage.getIncomplete();
        return new SuccessAnnounceResponse(interval, seeders, leechers);
    }

    @VisibleForTesting
    TrackerMessage makeCallAndGetResponseAsByteBuffer(URI announceUri, String requestQuery, Iterable<Map.Entry<String, String>> headers) throws AnnounceException {
        HttpResponse response;
        String base = announceUri + (announceUri.toString().contains("?") ? "&" : "?");
        HttpGet request = new HttpGet(base + requestQuery);
        Object host = announceUri.getHost();
        if (announceUri.getPort() != -1) {
            host = (String)host + ":" + announceUri.getPort();
        }
        request.addHeader("Host", (String)host);
        headers.forEach(arg_0 -> TrackerClient.lambda$makeCallAndGetResponseAsByteBuffer$0((HttpUriRequest)request, arg_0));
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            throw new AnnounceException("Failed to announce: protocol mismatch", (Throwable)e);
        }
        catch (IOException e) {
            throw new AnnounceException("Failed to announce: error or connection aborted", (Throwable)e);
        }
        try {
            return (TrackerMessage)this.handleResponse(response, this.trackerResponseHandler);
        }
        catch (IOException e) {
            throw new AnnounceException("Failed to handle tracker response: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleResponse(HttpResponse response, ResponseHandler<T> handler) throws ClientProtocolException, IOException {
        Object object = handler.handleResponse(response);
        return (T)object;
        finally {
            try {
                HttpEntity entity = response.getEntity();
                InputStream content = entity.getContent();
                if (content != null) {
                    content.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public TrackerClient(TrackerClientUriProvider trackerClientUriProvider, ResponseHandler<TrackerMessage> trackerResponseHandler, HttpClient httpClient) {
        this.trackerClientUriProvider = trackerClientUriProvider;
        this.trackerResponseHandler = trackerResponseHandler;
        this.httpClient = httpClient;
    }

    private static /* synthetic */ void lambda$makeCallAndGetResponseAsByteBuffer$0(HttpUriRequest request, Map.Entry hdrEntry) {
        request.addHeader((String)hdrEntry.getKey(), (String)hdrEntry.getValue());
    }
}

