/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.response;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import org.araymond.joal.core.ttorrent.client.Client;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNotifier
implements AnnounceResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientNotifier.class);
    private final Client client;

    public void onAnnouncerWillAnnounce(Announcer announcer, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
    }

    public void onAnnounceStartSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        if (result.getSeeders() < 1 || result.getLeechers() < 1) {
            this.client.onNoMorePeers(announcer.getTorrentInfoHash());
        }
    }

    public void onAnnounceStartFails(Announcer announcer, Throwable throwable) {
    }

    public void onAnnounceRegularSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        if (result.getSeeders() < 1 || result.getLeechers() < 1) {
            this.client.onNoMorePeers(announcer.getTorrentInfoHash());
            return;
        }
        if (announcer.hasReachedUploadRatioLimit()) {
            this.client.onUploadRatioLimitReached(announcer.getTorrentInfoHash());
        }
    }

    public void onAnnounceRegularFails(Announcer announcer, Throwable throwable) {
    }

    public void onAnnounceStopSuccess(Announcer announcer, SuccessAnnounceResponse result) {
        log.debug("Notify client that a torrent has stopped");
        this.client.onTorrentHasStopped(announcer);
    }

    public void onAnnounceStopFails(Announcer announcer, Throwable throwable) {
    }

    public void onTooManyAnnounceFailedInARow(Announcer announcer, TooManyAnnouncesFailedInARowException e) {
        log.debug("Notify client that a torrent has failed too many times");
        this.client.onTooManyFailedInARow(announcer);
    }

    public ClientNotifier(Client client) {
        this.client = client;
    }
}

