/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.ttorrent.client.announcer.response;

import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.util.ArrayList;
import java.util.List;
import org.araymond.joal.core.ttorrent.client.announcer.Announcer;
import org.araymond.joal.core.ttorrent.client.announcer.exceptions.TooManyAnnouncesFailedInARowException;
import org.araymond.joal.core.ttorrent.client.announcer.request.SuccessAnnounceResponse;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseCallback;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandler;
import org.araymond.joal.core.ttorrent.client.announcer.response.AnnounceResponseHandlerChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnounceResponseHandlerChain
implements AnnounceResponseCallback {
    private static final Logger log = LoggerFactory.getLogger(AnnounceResponseHandlerChain.class);
    private final List<AnnounceResponseHandler> handlers = new ArrayList();

    public void appendHandler(AnnounceResponseHandler element) {
        this.handlers.add(element);
    }

    public void onAnnounceWillAnnounce(TrackerMessage.AnnounceRequestMessage.RequestEvent event, Announcer announcer) {
        this.handlers.forEach(e -> e.onAnnouncerWillAnnounce(announcer, event));
    }

    public void onAnnounceSuccess(TrackerMessage.AnnounceRequestMessage.RequestEvent event, Announcer announcer, SuccessAnnounceResponse result) {
        this.handlers.forEach(handler -> {
            switch (1.$SwitchMap$com$turn$ttorrent$common$protocol$TrackerMessage$AnnounceRequestMessage$RequestEvent[event.ordinal()]) {
                case 1: {
                    handler.onAnnounceStartSuccess(announcer, result);
                    break;
                }
                case 2: {
                    handler.onAnnounceRegularSuccess(announcer, result);
                    break;
                }
                case 3: {
                    handler.onAnnounceStopSuccess(announcer, result);
                    break;
                }
                default: {
                    log.warn("Event [{}] cannot be handled by {}", (Object)event.getEventName(), (Object)this.getClass().getSimpleName());
                }
            }
        });
    }

    public void onAnnounceFailure(TrackerMessage.AnnounceRequestMessage.RequestEvent event, Announcer announcer, Throwable throwable) {
        this.handlers.forEach(handler -> {
            switch (1.$SwitchMap$com$turn$ttorrent$common$protocol$TrackerMessage$AnnounceRequestMessage$RequestEvent[event.ordinal()]) {
                case 1: {
                    handler.onAnnounceStartFails(announcer, throwable);
                    break;
                }
                case 2: {
                    handler.onAnnounceRegularFails(announcer, throwable);
                    break;
                }
                case 3: {
                    handler.onAnnounceStopFails(announcer, throwable);
                    break;
                }
                default: {
                    log.warn("Event [{}] cannot be handled by {}", (Object)event.getEventName(), (Object)this.getClass().getSimpleName());
                }
            }
        });
    }

    public void onTooManyAnnounceFailedInARow(TrackerMessage.AnnounceRequestMessage.RequestEvent event, Announcer announcer, TooManyAnnouncesFailedInARowException e) {
        this.handlers.forEach(h -> h.onTooManyAnnounceFailedInARow(announcer, e));
    }
}

