/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.torrent.watcher;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TorrentFileWatcher {
    private static final Logger log = LoggerFactory.getLogger(TorrentFileWatcher.class);
    private static final long DEFAULT_SCAN_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final IOFileFilter TORRENT_FILE_FILTER = FileFilterUtils.suffixFileFilter((String)".torrent");
    private final FileAlterationObserver observer;
    private final FileAlterationListener listener;
    private final File monitoredFolder;
    private final FileAlterationMonitor monitor;

    TorrentFileWatcher(FileAlterationListener listener, Path monitoredFolder) {
        this(listener, monitoredFolder, DEFAULT_SCAN_INTERVAL_MS);
    }

    TorrentFileWatcher(FileAlterationListener listener, Path monitoredFolder, long intervalMs) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener cannot be null");
        Preconditions.checkNotNull((Object)monitoredFolder, (Object)"monitoredFolder cannot be null");
        Preconditions.checkArgument((boolean)Files.isDirectory(monitoredFolder, new LinkOption[0]), (Object)("Folder [" + monitoredFolder.toAbsolutePath() + "] does not exists."));
        Preconditions.checkArgument((intervalMs > 0L ? 1 : 0) != 0, (Object)"intervalMs cannot be less than 1");
        this.listener = listener;
        this.monitoredFolder = monitoredFolder.toFile();
        this.observer = new FileAlterationObserver(this.monitoredFolder, (FileFilter)TORRENT_FILE_FILTER);
        this.observer.addListener(this.listener);
        this.monitor = new FileAlterationMonitor(intervalMs);
        this.monitor.setThreadFactory(new ThreadFactoryBuilder().setNameFormat("torrent-file-watcher-%d").build());
        this.monitor.addObserver(this.observer);
    }

    void start() {
        try {
            if (!this.monitoredFolder.exists()) {
                throw new IllegalArgumentException(String.format("Torrent directory [%s] does not exist", this.monitoredFolder));
            }
            this.monitor.start();
            FileUtils.listFiles((File)this.monitoredFolder, (IOFileFilter)TORRENT_FILE_FILTER, null).forEach(arg_0 -> ((FileAlterationListener)this.listener).onFileCreate(arg_0));
        }
        catch (Exception e) {
            log.error("Failed to start torrent file monitoring", (Throwable)e);
            throw new IllegalStateException("Failed to start torrent file monitoring", e);
        }
    }

    void stop() {
        log.trace("Stopping TorrentFileProvider...");
        this.observer.getListeners().forEach(arg_0 -> ((FileAlterationObserver)this.observer).removeListener(arg_0));
        try {
            this.monitor.stop(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.trace("TorrentFileProvider stopped");
    }
}

