/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.key.algorithm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.araymond.joal.core.client.emulated.generator.key.algorithm.KeyAlgorithm;

public class HashNoLeadingZeroKeyAlgorithm
implements KeyAlgorithm {
    @JsonProperty(value="length")
    private final int length;

    public HashNoLeadingZeroKeyAlgorithm(@JsonProperty(value="length", required=true) int length) {
        this.length = length;
    }

    @VisibleForTesting
    String removeLeadingZeroes(String string) {
        return StringUtils.stripStart((String)string, (String)"0");
    }

    public String generate() {
        return this.removeLeadingZeroes(RandomStringUtils.random((int)this.length, (char[])new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'}));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashNoLeadingZeroKeyAlgorithm)) {
            return false;
        }
        HashNoLeadingZeroKeyAlgorithm other = (HashNoLeadingZeroKeyAlgorithm)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HashNoLeadingZeroKeyAlgorithm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLength();
        return result;
    }

    public int getLength() {
        return this.length;
    }
}

