/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.araymond.joal.core.client.emulated.generator.key.KeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.TorrentPersistentRefreshKeyGenerator;
import org.araymond.joal.core.client.emulated.generator.key.algorithm.KeyAlgorithm;
import org.araymond.joal.core.client.emulated.utils.Casing;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class TorrentPersistentRefreshKeyGenerator
extends KeyGenerator {
    private final Map<InfoHash, AccessAwareKey> keyPerTorrent = new ConcurrentHashMap();

    @JsonCreator
    TorrentPersistentRefreshKeyGenerator(@JsonProperty(value="algorithm", required=true) KeyAlgorithm algorithm, @JsonProperty(value="keyCase", required=true) Casing keyCase) {
        super(algorithm, keyCase);
    }

    public String getKey(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        if (!this.keyPerTorrent.containsKey(infoHash)) {
            this.keyPerTorrent.put(infoHash, new AccessAwareKey(super.generateKey()));
        }
        String key = ((AccessAwareKey)this.keyPerTorrent.get(infoHash)).getPeerId();
        this.evictOldEntries();
        return key;
    }

    private void evictOldEntries() {
        new HashSet(this.keyPerTorrent.entrySet()).stream().filter(arg_0 -> this.shouldEvictEntry(arg_0)).forEach(entry -> this.keyPerTorrent.remove(entry.getKey()));
    }

    @VisibleForTesting
    boolean shouldEvictEntry(Map.Entry<InfoHash, AccessAwareKey> entry) {
        return ChronoUnit.MINUTES.between(entry.getValue().getLastAccess(), LocalDateTime.now()) >= 120L;
    }
}

