/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Provider;
import org.araymond.joal.core.SeedManager;
import org.araymond.joal.core.client.emulated.BitTorrentClient;
import org.araymond.joal.core.client.emulated.BitTorrentClientConfig;
import org.araymond.joal.core.client.emulated.BitTorrentClientProvider;
import org.araymond.joal.core.client.emulated.generator.numwant.NumwantProvider;
import org.araymond.joal.core.config.JoalConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitTorrentClientProvider
implements Provider<BitTorrentClient> {
    private static final Logger log = LoggerFactory.getLogger(BitTorrentClientProvider.class);
    private BitTorrentClient bitTorrentClient;
    private final JoalConfigProvider configProvider;
    private final ObjectMapper objectMapper;
    private final Path clientsFolderPath;

    public BitTorrentClientProvider(JoalConfigProvider configProvider, ObjectMapper objectMapper, SeedManager.JoalFoldersPath joalFoldersPath) {
        this.configProvider = configProvider;
        this.objectMapper = objectMapper;
        this.clientsFolderPath = joalFoldersPath.getClientFilesDirPath();
    }

    public List<String> listClientFiles() {
        List<String> list;
        block8: {
            Stream<Path> paths = Files.walk(this.clientsFolderPath, FileVisitOption.FOLLOW_LINKS);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).filter(name -> name.endsWith(".client")).sorted((Comparator<String>)new SemanticVersionFilenameComparator()).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to walk through .clients files in [" + this.clientsFolderPath + "]", e);
                }
            }
            paths.close();
        }
        return list;
    }

    public BitTorrentClient get() {
        if (this.bitTorrentClient == null) {
            try {
                this.generateNewClient();
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.bitTorrentClient;
    }

    public BitTorrentClient generateNewClient() throws FileNotFoundException, IllegalStateException {
        log.debug("Generating new client...");
        Path clientConfigPath = this.clientsFolderPath.resolve(this.configProvider.get().getClient());
        if (!Files.isRegularFile(clientConfigPath, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("BitTorrent client configuration file [%s] not found", clientConfigPath.toAbsolutePath()));
        }
        try {
            BitTorrentClientConfig config = (BitTorrentClientConfig)this.objectMapper.readValue(clientConfigPath.toFile(), BitTorrentClientConfig.class);
            this.bitTorrentClient = this.createClient(config);
            log.debug("New client successfully generated");
            return this.bitTorrentClient;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BitTorrentClient createClient(BitTorrentClientConfig clientConfig) {
        return new BitTorrentClient(clientConfig.getPeerIdGenerator(), clientConfig.getKeyGenerator(), clientConfig.getUrlEncoder(), clientConfig.getQuery(), (Collection)ImmutableList.copyOf((Collection)clientConfig.getRequestHeaders()), new NumwantProvider(clientConfig.getNumwant(), clientConfig.getNumwantOnStop()));
    }
}

