/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.araymond.joal.core.SeedManager;
import org.araymond.joal.core.bandwith.BandwidthDispatcher;
import org.araymond.joal.core.bandwith.BandwidthDispatcherFacade;
import org.araymond.joal.core.bandwith.RandomSpeedProvider;
import org.araymond.joal.core.bandwith.Speed;
import org.araymond.joal.core.bandwith.SpeedChangedListener;
import org.araymond.joal.core.client.emulated.BitTorrentClient;
import org.araymond.joal.core.client.emulated.BitTorrentClientProvider;
import org.araymond.joal.core.config.AppConfiguration;
import org.araymond.joal.core.config.JoalConfigProvider;
import org.araymond.joal.core.events.config.ListOfClientFilesEvent;
import org.araymond.joal.core.events.global.state.GlobalSeedStartedEvent;
import org.araymond.joal.core.events.global.state.GlobalSeedStoppedEvent;
import org.araymond.joal.core.events.torrent.files.FailedToAddTorrentFileEvent;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.torrent.torrent.MockedTorrent;
import org.araymond.joal.core.torrent.watcher.TorrentFileProvider;
import org.araymond.joal.core.ttorrent.client.ClientBuilder;
import org.araymond.joal.core.ttorrent.client.ClientFacade;
import org.araymond.joal.core.ttorrent.client.ConnectionHandler;
import org.araymond.joal.core.ttorrent.client.DelayQueue;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFacade;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFactory;
import org.araymond.joal.core.ttorrent.client.announcer.request.AnnounceDataAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class SeedManager {
    private static final Logger log = LoggerFactory.getLogger(SeedManager.class);
    private final CloseableHttpClient httpClient;
    private boolean seeding;
    private final JoalFoldersPath joalFoldersPath;
    private final JoalConfigProvider configProvider;
    private final TorrentFileProvider torrentFileProvider;
    private final BitTorrentClientProvider bitTorrentClientProvider;
    private final ApplicationEventPublisher appEventPublisher;
    private final ConnectionHandler connectionHandler = new ConnectionHandler();
    private BandwidthDispatcher bandwidthDispatcher;
    private ClientFacade client;

    public SeedManager(String joalConfRootPath, ObjectMapper mapper, ApplicationEventPublisher appEventPublisher) throws IOException {
        this.joalFoldersPath = new JoalFoldersPath(Paths.get(joalConfRootPath, new String[0]));
        this.torrentFileProvider = new TorrentFileProvider(this.joalFoldersPath);
        this.configProvider = new JoalConfigProvider(mapper, this.joalFoldersPath, appEventPublisher);
        this.bitTorrentClientProvider = new BitTorrentClientProvider(this.configProvider, mapper, this.joalFoldersPath);
        this.appEventPublisher = appEventPublisher;
        SocketConfig sc = SocketConfig.custom().setSoTimeout(30000).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(100);
        connManager.setMaxTotal(200);
        connManager.setValidateAfterInactivity(1000);
        connManager.setDefaultSocketConfig(sc);
        RequestConfig requestConf = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        this.httpClient = HttpClients.custom().setConnectionTimeToLive(1L, TimeUnit.MINUTES).setConnectionManager((HttpClientConnectionManager)connManager).setConnectionManagerShared(true).setDefaultRequestConfig(requestConf).build();
    }

    public void init() throws IOException {
        this.connectionHandler.start();
        this.torrentFileProvider.start();
    }

    public void tearDown() {
        this.connectionHandler.close();
        this.torrentFileProvider.stop();
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }

    public void startSeeding() throws IOException {
        if (this.seeding) {
            log.warn("startSeeding() called, but already running");
            return;
        }
        this.seeding = true;
        AppConfiguration appConfig = this.configProvider.init();
        this.appEventPublisher.publishEvent((Object)new ListOfClientFilesEvent(this.listClientFiles()));
        BitTorrentClient bitTorrentClient = this.bitTorrentClientProvider.generateNewClient();
        this.bandwidthDispatcher = new BandwidthDispatcher(5000, new RandomSpeedProvider(appConfig));
        this.bandwidthDispatcher.setSpeedListener((SpeedChangedListener)new SeedManagerSpeedChangeListener(this.appEventPublisher));
        this.bandwidthDispatcher.start();
        AnnounceDataAccessor announceDataAccessor = new AnnounceDataAccessor(bitTorrentClient, (BandwidthDispatcherFacade)this.bandwidthDispatcher, this.connectionHandler);
        this.client = ClientBuilder.builder().withAppConfiguration(appConfig).withTorrentFileProvider(this.torrentFileProvider).withBandwidthDispatcher(this.bandwidthDispatcher).withAnnouncerFactory(new AnnouncerFactory(announceDataAccessor, (HttpClient)this.httpClient, appConfig)).withEventPublisher(this.appEventPublisher).withDelayQueue(new DelayQueue()).build();
        this.client.start();
        this.appEventPublisher.publishEvent((Object)new GlobalSeedStartedEvent(bitTorrentClient));
    }

    public void saveNewConfiguration(AppConfiguration config) {
        this.configProvider.saveNewConf(config);
    }

    public void saveTorrentToDisk(String name, byte[] bytes) {
        try {
            MockedTorrent.fromBytes((byte[])bytes);
            Object torrentName = name.endsWith(".torrent") ? name : name + ".torrent";
            Files.write(this.joalFoldersPath.getTorrentsDirPath().resolve((String)torrentName), bytes, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            log.warn("Failed to save torrent file", (Throwable)e);
            String errorMessage = (String)ObjectUtils.firstNonNull((Object[])new String[]{e.getMessage(), "Empty/bad file"});
            this.appEventPublisher.publishEvent((Object)new FailedToAddTorrentFileEvent(name, errorMessage));
        }
    }

    public void deleteTorrent(InfoHash torrentInfoHash) {
        this.torrentFileProvider.moveToArchiveFolder(torrentInfoHash);
    }

    public List<MockedTorrent> getTorrentFiles() {
        return this.torrentFileProvider.getTorrentFiles();
    }

    public List<String> listClientFiles() {
        return this.bitTorrentClientProvider.listClientFiles();
    }

    public List<AnnouncerFacade> getCurrentlySeedingAnnouncers() {
        return this.client == null ? Collections.emptyList() : this.client.getCurrentlySeedingAnnouncers();
    }

    public Map<InfoHash, Speed> getSpeedMap() {
        return this.bandwidthDispatcher == null ? Collections.emptyMap() : this.bandwidthDispatcher.getSpeedMap();
    }

    public AppConfiguration getCurrentConfig() {
        try {
            return this.configProvider.get();
        }
        catch (IllegalStateException e) {
            return this.configProvider.init();
        }
    }

    public String getCurrentEmulatedClient() {
        try {
            return this.bitTorrentClientProvider.get().getHeaders().stream().filter(hdr -> "User-Agent".equalsIgnoreCase((String)hdr.getKey())).findFirst().map(Map.Entry::getValue).orElse("Unknown");
        }
        catch (IllegalStateException e) {
            return "None";
        }
    }

    public void stop() {
        this.seeding = false;
        if (this.client != null) {
            this.client.stop();
            this.appEventPublisher.publishEvent((Object)new GlobalSeedStoppedEvent());
            this.client = null;
        }
        if (this.bandwidthDispatcher != null) {
            this.bandwidthDispatcher.stop();
            this.bandwidthDispatcher.setSpeedListener(null);
            this.bandwidthDispatcher = null;
        }
    }

    public boolean isSeeding() {
        return this.seeding;
    }
}

