/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.services.corelistener;

import javax.inject.Inject;
import org.araymond.joal.core.events.speed.SeedingSpeedsHasChangedEvent;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.impl.speed.SeedingSpeedHasChangedPayload;
import org.araymond.joal.web.services.JoalMessageSendingTemplate;
import org.araymond.joal.web.services.corelistener.WebEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@ConditionalOnWebUi
@Service
public class WebSpeedEventListener
extends WebEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebSpeedEventListener.class);

    @Inject
    public WebSpeedEventListener(JoalMessageSendingTemplate messagingTemplate) {
        super(messagingTemplate);
    }

    @Order(value=0x7FFFFFFF)
    @EventListener
    public void failedToAnnounce(SeedingSpeedsHasChangedEvent event) {
        log.debug("Send SeedingSpeedHasChangedPayload to clients.");
        this.messagingTemplate.convertAndSend("/speed", (MessagePayload)new SeedingSpeedHasChangedPayload(event));
    }
}

