/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.messages.outgoing.impl.announce;

import java.time.LocalDateTime;
import org.araymond.joal.core.torrent.torrent.InfoHash;
import org.araymond.joal.core.ttorrent.client.announcer.AnnouncerFacade;
import org.araymond.joal.web.messages.outgoing.MessagePayload;

public abstract class AnnouncePayload
implements MessagePayload {
    private final InfoHash infoHash;
    private final String torrentName;
    private final long torrentSize;
    private final int lastKnownInterval;
    private final int consecutiveFails;
    private final LocalDateTime lastAnnouncedAt;
    private final Integer lastKnownLeechers;
    private final Integer lastKnownSeeders;

    protected AnnouncePayload(AnnouncerFacade announcerFacade) {
        this.infoHash = announcerFacade.getTorrentInfoHash();
        this.torrentName = announcerFacade.getTorrentName();
        this.torrentSize = announcerFacade.getTorrentSize();
        this.lastKnownInterval = announcerFacade.getLastKnownInterval();
        this.consecutiveFails = announcerFacade.getConsecutiveFails();
        this.lastAnnouncedAt = announcerFacade.getLastAnnouncedAt().orElse(null);
        this.lastKnownLeechers = announcerFacade.getLastKnownLeechers().orElse(null);
        this.lastKnownSeeders = announcerFacade.getLastKnownSeeders().orElse(null);
    }

    public InfoHash getInfoHash() {
        return this.infoHash;
    }

    public String getTorrentName() {
        return this.torrentName;
    }

    public long getTorrentSize() {
        return this.torrentSize;
    }

    public int getLastKnownInterval() {
        return this.lastKnownInterval;
    }

    public int getConsecutiveFails() {
        return this.consecutiveFails;
    }

    public LocalDateTime getLastAnnouncedAt() {
        return this.lastAnnouncedAt;
    }

    public Integer getLastKnownLeechers() {
        return this.lastKnownLeechers;
    }

    public Integer getLastKnownSeeders() {
        return this.lastKnownSeeders;
    }
}

