/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.messages.outgoing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.araymond.joal.web.messages.outgoing.MessagePayload;
import org.araymond.joal.web.messages.outgoing.StompMessageTypes;

public class StompMessage {
    private final StompMessageTypes type;
    private final MessagePayload payload;

    @VisibleForTesting
    StompMessage(StompMessageTypes type, MessagePayload payload) {
        Preconditions.checkNotNull((Object)type, (Object)"Type must not be null or empty.");
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null or empty.");
        this.type = type;
        this.payload = payload;
    }

    public static StompMessage wrap(MessagePayload payload) {
        return new StompMessage(StompMessageTypes.typeFor((MessagePayload)payload), payload);
    }

    public StompMessageTypes getType() {
        return this.type;
    }

    public MessagePayload getPayload() {
        return this.payload;
    }
}

