/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.web.config.obfuscation;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.araymond.joal.web.annotations.ConditionalOnWebUi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@ConditionalOnWebUi
@Component
@Order(value=-2147483648)
public class AbortNonPrefixedRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbortNonPrefixedRequestFilter.class);
    private final String pathPrefix;

    public AbortNonPrefixedRequestFilter(@Value(value="${joal.ui.path.prefix}") String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String requestedUri = req.getRequestURI();
        if (requestedUri.startsWith("/")) {
            requestedUri = requestedUri.substring(1);
        }
        if (!requestedUri.startsWith(this.pathPrefix)) {
            log.warn("Request was sent to URI [{}] and does not match the path prefix, therefore the request Thread has been shut down", (Object)req.getRequestURI());
            Thread.currentThread().interrupt();
            return;
        }
        chain.doFilter(request, response);
    }
}

