/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.torrent.torrent;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.InvalidBEncodingException;
import com.turn.ttorrent.common.Torrent;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class MockedTorrent
extends Torrent {
    public static final Charset BYTE_ENCODING = Charset.forName("ISO-8859-1");
    private final InfoHash torrentInfoHash;

    private MockedTorrent(byte[] torrent) throws IOException, NoSuchAlgorithmException {
        super(torrent, false);
        try {
            int pieceLength = ((BEValue)this.decoded_info.get("piece length")).getInt();
            ByteBuffer piecesHashes = ByteBuffer.wrap(((BEValue)this.decoded_info.get("pieces")).getBytes());
            if ((long)(piecesHashes.capacity() / 20) * (long)pieceLength < this.getSize()) {
                throw new IllegalArgumentException("Torrent size does not match the number of pieces and the piece size!");
            }
        }
        catch (InvalidBEncodingException ex) {
            throw new IllegalArgumentException("Error reading torrent meta-info fields!", ex);
        }
        this.torrentInfoHash = new InfoHash(this.getInfoHash());
    }

    public static MockedTorrent fromFile(File torrentFile) throws IOException, NoSuchAlgorithmException {
        byte[] data = FileUtils.readFileToByteArray((File)torrentFile);
        return new MockedTorrent(data);
    }

    public static MockedTorrent fromBytes(byte[] bytes) throws IOException, NoSuchAlgorithmException {
        return new MockedTorrent(bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockedTorrent)) {
            return false;
        }
        MockedTorrent other = (MockedTorrent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        InfoHash this$torrentInfoHash = this.getTorrentInfoHash();
        InfoHash other$torrentInfoHash = other.getTorrentInfoHash();
        return !(this$torrentInfoHash == null ? other$torrentInfoHash != null : !this$torrentInfoHash.equals(other$torrentInfoHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MockedTorrent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InfoHash $torrentInfoHash = this.getTorrentInfoHash();
        result = result * 59 + ($torrentInfoHash == null ? 43 : $torrentInfoHash.hashCode());
        return result;
    }

    public InfoHash getTorrentInfoHash() {
        return this.torrentInfoHash;
    }
}

