/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.araymond.joal.core.config.AppConfigurationIntegrityException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppConfiguration {
    private final long minUploadRate;
    private final long maxUploadRate;
    private final int simultaneousSeed;
    private final String client;
    private final boolean keepTorrentWithZeroLeechers;
    private final float uploadRatioTarget;

    @JsonCreator
    public AppConfiguration(@JsonProperty(value="minUploadRate", required=true) long minUploadRate, @JsonProperty(value="maxUploadRate", required=true) long maxUploadRate, @JsonProperty(value="simultaneousSeed", required=true) int simultaneousSeed, @JsonProperty(value="client", required=true) String client, @JsonProperty(value="keepTorrentWithZeroLeechers", required=true) boolean keepTorrentWithZeroLeechers, @JsonProperty(value="uploadRatioTarget", required=false) Float uploadRatioTarget) {
        this.minUploadRate = minUploadRate;
        this.maxUploadRate = maxUploadRate;
        this.simultaneousSeed = simultaneousSeed;
        this.client = client;
        this.keepTorrentWithZeroLeechers = keepTorrentWithZeroLeechers;
        this.uploadRatioTarget = uploadRatioTarget == null ? -1.0f : uploadRatioTarget.floatValue();
        this.validate();
    }

    private void validate() {
        if (this.minUploadRate < 0L) {
            throw new AppConfigurationIntegrityException("minUploadRate must be at least 0");
        }
        if (this.maxUploadRate < 0L) {
            throw new AppConfigurationIntegrityException("maxUploadRate must greater or equal to 0");
        }
        if (this.maxUploadRate < this.minUploadRate) {
            throw new AppConfigurationIntegrityException("maxUploadRate must be greater or equal to minUploadRate");
        }
        if (this.simultaneousSeed < 1) {
            throw new AppConfigurationIntegrityException("simultaneousSeed must be greater than 0");
        }
        if (StringUtils.isBlank((CharSequence)this.client)) {
            throw new AppConfigurationIntegrityException("client is required, no file name given");
        }
        if (this.uploadRatioTarget < 0.0f && this.uploadRatioTarget != -1.0f) {
            throw new AppConfigurationIntegrityException("uploadRatioTarget must be greater than 0 (or equal to -1)");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppConfiguration)) {
            return false;
        }
        AppConfiguration other = (AppConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMinUploadRate() != other.getMinUploadRate()) {
            return false;
        }
        if (this.getMaxUploadRate() != other.getMaxUploadRate()) {
            return false;
        }
        if (this.getSimultaneousSeed() != other.getSimultaneousSeed()) {
            return false;
        }
        if (this.isKeepTorrentWithZeroLeechers() != other.isKeepTorrentWithZeroLeechers()) {
            return false;
        }
        if (Float.compare(this.getUploadRatioTarget(), other.getUploadRatioTarget()) != 0) {
            return false;
        }
        String this$client = this.getClient();
        String other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minUploadRate = this.getMinUploadRate();
        result = result * 59 + (int)($minUploadRate >>> 32 ^ $minUploadRate);
        long $maxUploadRate = this.getMaxUploadRate();
        result = result * 59 + (int)($maxUploadRate >>> 32 ^ $maxUploadRate);
        result = result * 59 + this.getSimultaneousSeed();
        result = result * 59 + (this.isKeepTorrentWithZeroLeechers() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getUploadRatioTarget());
        String $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public long getMinUploadRate() {
        return this.minUploadRate;
    }

    public long getMaxUploadRate() {
        return this.maxUploadRate;
    }

    public int getSimultaneousSeed() {
        return this.simultaneousSeed;
    }

    public String getClient() {
        return this.client;
    }

    public boolean isKeepTorrentWithZeroLeechers() {
        return this.keepTorrentWithZeroLeechers;
    }

    public float getUploadRatioTarget() {
        return this.uploadRatioTarget;
    }
}

